/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.node;

import com.ibm.arcs.basic.node.Node;
import com.ibm.arcs.basic.node.iterator.fast.NodeLevelOrderIteratorFast;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NodeUtils {
    public static <T extends Node<T>> List<T> getPathToRoot(T t) {
        ArrayList arrayList = new ArrayList();
        NodeUtils.getPathToRootRecursive(t, arrayList);
        return Collections.unmodifiableList(arrayList);
    }

    private static <T extends Node<T>> void getPathToRootRecursive(T t, ArrayList<T> arrayList) {
        arrayList.add(t);
        Node node = (Node)t.getParent();
        if (node != null) {
            NodeUtils.getPathToRootRecursive(node, arrayList);
        }
    }

    public static <T extends Node<T>> T getRoot(T t) {
        if (t.hasParent()) {
            return (T)((Node)t.getRoot());
        }
        return t;
    }

    public static <T extends Node<T>> List<T> getLeavesCanonical(T t) {
        return NodeUtils.getLeavesRelative(NodeUtils.getRoot(t));
    }

    public static <T extends Node<T>> List<T> getLeavesRelative(T t) {
        Node node;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeLevelOrderIteratorFast<T> nodeLevelOrderIteratorFast = new NodeLevelOrderIteratorFast<T>(t);
        while ((node = (Node)nodeLevelOrderIteratorFast.next()) != null) {
            if (node.hasChildren()) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public static <T extends Node<T>> int getDepth(T t) {
        if (t.getParent() != null) {
            return 1 + NodeUtils.getDepth((Node)t.getParent());
        }
        return 1;
    }

    public static <T extends Node<T>> int getDepthToPseudoRoot(T t, T t2) {
        int n = 0;
        Object object = t;
        while (object != null && object != t2) {
            object = (Node)object.getParent();
            ++n;
        }
        return n;
    }

    public static <T extends Node<T>> int getTreeHeight(T t) {
        int n = 1;
        List<T> list = NodeUtils.getLeavesCanonical(t);
        for (T t2 : list) {
            int n2 = NodeUtils.getDepth(t2);
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    public static <T extends Node<T>> List<T> getPath(T t, T t2) {
        List<T> list;
        List<T> list2 = NodeUtils.getPathToRoot(t);
        if (!NodeUtils.lastNodesEqual(list2, list = NodeUtils.getPathToRoot(t2))) {
            throw new IllegalArgumentException("start and end nodes do not share a common root");
        }
        Collections.reverse(list);
        int n = 0;
        int n2 = 0;
        for (T t3 : list2) {
            if (list.indexOf(t3) != -1) {
                n2 = list.indexOf(t3);
                break;
            }
            ++n;
        }
        int n3 = 2 + n + n2;
        ArrayList arrayList = new ArrayList(n3);
        int n4 = 0;
        while (n4 <= n) {
            arrayList.set(n4, list2.get(n4));
            ++n4;
        }
        n4 = list.size();
        int n5 = n2 + 1;
        while (n5 < n4) {
            arrayList.set(n + n5, list2.get(n5));
            ++n5;
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static <T extends Node<T>> boolean lastNodesEqual(List<T> list, List<T> list2) {
        T t;
        T t2 = NodeUtils.getLastNodeInList(list);
        return t2 == (t = NodeUtils.getLastNodeInList(list2));
    }

    private static <T extends Node<T>> T getLastNodeInList(List<T> list) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("List must be non-zero size");
        }
        return (T)((Node)list.get(list.size() - 1));
    }
}

