/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.node.iterator;

import com.ibm.arcs.basic.node.Node;
import com.ibm.arcs.basic.node.NodeLocation;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class NodeLocationIterator<T extends Node<T>>
implements ListIterator<T> {
    private static final int lowestDepthIndex = -1;
    private final NodeLocation<T> location;
    private final T root;
    private int depthIndex = -1;

    public NodeLocationIterator(T t, NodeLocation<T> nodeLocation) {
        this.root = t;
        this.location = nodeLocation;
    }

    @Override
    public boolean hasNext() {
        return this.depthIndex < this.location.getDepth();
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            ++this.depthIndex;
            return this.location.get(this.root, this.depthIndex);
        }
        throw new NoSuchElementException("No next element exists");
    }

    @Override
    public boolean hasPrevious() {
        return this.depthIndex != -1;
    }

    @Override
    public T previous() {
        if (this.hasPrevious()) {
            --this.depthIndex;
            return this.location.get(this.root, this.depthIndex);
        }
        throw new NoSuchElementException("No next element exists");
    }

    @Override
    public int nextIndex() {
        if (this.hasNext()) {
            return this.depthIndex + 1;
        }
        return this.location.getDepth();
    }

    @Override
    public int previousIndex() {
        if (this.hasPrevious()) {
            return this.depthIndex - 1;
        }
        return -1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(T t) {
        throw new UnsupportedOperationException();
    }
}

