/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.node.iterator.compact;

import com.ibm.arcs.basic.node.Node;
import com.ibm.arcs.basic.node.NodeUtils;
import com.ibm.arcs.basic.node.iterator.NodeIterator;
import com.ibm.arcs.basic.node.iterator.fast.NodePreOrderIteratorFast;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeIDDFSIterator<T extends Node<T>>
implements NodeIterator<T> {
    protected final int maxDepth;
    protected T rootNode;
    protected T currentNode;
    protected T nextNode;
    protected int targetDepth = 0;
    protected NodeIterator<T> depthFirstIterator;
    protected Logger logger;

    public NodeIDDFSIterator(T t) {
        this(t, -1);
    }

    public NodeIDDFSIterator(T t, int n) {
        this.rootNode = t;
        this.currentNode = null;
        this.nextNode = t;
        this.depthFirstIterator = new NodePreOrderIteratorFast<T>(t);
        this.maxDepth = n;
        this.logger = LoggerFactory.getLogger(NodeIDDFSIterator.class);
    }

    @Override
    public boolean hasNext() {
        return this.nextNode != null;
    }

    @Override
    public T next() {
        if (this.nextNode != null) {
            T t = this.nextNode;
            this.nextNode();
            return t;
        }
        throw new RuntimeException("exceeded bounds of iterator");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDepth() {
        return NodeUtils.getDepthToPseudoRoot(this.currentNode, this.rootNode);
    }

    private void nextNode() {
        this.nextNode = (Node)this.depthFirstIterator.next();
    }
}

