/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.node.iterator.compact;

import com.ibm.arcs.basic.node.Node;
import com.ibm.arcs.basic.node.NodeNavigator;
import com.ibm.arcs.basic.node.NodeUtils;
import com.ibm.arcs.basic.node.iterator.NodeIterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeLevelOrderIterator<T extends Node<T>>
implements NodeIterator<T> {
    private final NodeNavigator<T> navigator;
    private final int maxDepth;
    private final T rootNode;
    private T nextNode;
    private T currentNode;
    private int targetDepth = 0;
    protected Logger logger;

    public NodeLevelOrderIterator(T t) {
        this(t, -1);
    }

    public NodeLevelOrderIterator(T t, int n) {
        this.navigator = new NodeNavigator<T>(t);
        this.maxDepth = n;
        this.rootNode = t;
        this.nextNode = t;
        this.currentNode = null;
        this.logger = LoggerFactory.getLogger(NodeLevelOrderIterator.class);
    }

    @Override
    public boolean hasNext() {
        return this.nextNode != null;
    }

    @Override
    public T next() {
        if (this.nextNode != null) {
            this.currentNode = this.navigator.getCurrentNode();
            this.nextNode();
            return this.currentNode;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDepth() {
        return NodeUtils.getDepthToPseudoRoot(this.currentNode, this.rootNode);
    }

    private void nextNode() {
        if (this.navigator.getDepth() == this.targetDepth) {
            this.logger.debug("at target depth");
            if (this.navigator.hasSiblingsToRight()) {
                this.logger.debug("has more siblings");
                this.navigator.navigateToSibling();
            } else {
                this.logger.debug("no more siblings, moving to parent next sibling");
                this.navigator.navigateToParentNextSibling();
                if (this.navigator.hasParent()) {
                    try {
                        this.navigator.navigateToTargetDepth(this.targetDepth);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.terminateOrMoveToNextLevel();
                    }
                } else {
                    this.logger.debug("not at root");
                    this.terminateOrMoveToNextLevel();
                }
            }
        } else {
            this.logger.debug("navigating to target depth");
            this.navigator.navigateToTargetDepth(this.targetDepth);
        }
    }

    private void terminateOrMoveToNextLevel() {
        if (this.navigator.hasLevel(this.targetDepth + 1)) {
            this.logger.debug("has next level");
            this.navigateToNextLevel();
        } else {
            this.logger.debug("no next level");
            this.nextNode = null;
        }
    }

    private void navigateToNextLevel() {
        this.logger.debug("navigating to next level");
        ++this.targetDepth;
        if (this.maxDepth == -1 || this.targetDepth <= this.maxDepth) {
            this.navigator.navigateToRoot();
            this.navigator.navigateToTargetDepth(this.targetDepth);
        } else {
            this.nextNode = null;
        }
    }
}

