/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.node.iterator.compact;

import com.ibm.arcs.basic.node.Node;
import com.ibm.arcs.basic.node.iterator.NodeIterator;
import com.ibm.arcs.basic.node.iterator.NodeIteratorFactory;
import com.ibm.arcs.basic.node.iterator.compact.NodeLevelOrderIterator;

public class NodeLevelOrderIteratorFactory<T extends Node<T>>
implements NodeIteratorFactory<T> {
    private volatile int maxDepth;

    public NodeLevelOrderIteratorFactory() {
        this.maxDepth = -1;
    }

    public NodeLevelOrderIteratorFactory(int n) {
        this.maxDepth = n;
    }

    @Override
    public void setMaxDepth(int n) {
        this.maxDepth = n;
    }

    @Override
    public void setMaxDepthUnlimited() {
        this.maxDepth = -1;
    }

    @Override
    public NodeIterator<T> create(T t) {
        if (this.maxDepth == -1) {
            return new NodeLevelOrderIterator<T>(t);
        }
        return new NodeLevelOrderIterator<T>(t, this.maxDepth);
    }
}

