/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.node.iterator.compact;

import com.ibm.arcs.basic.node.Node;
import com.ibm.arcs.basic.node.NodeNavigator;
import com.ibm.arcs.basic.node.NodeUtils;
import com.ibm.arcs.basic.node.iterator.NodeIterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodePreOrderIterator<T extends Node<T>>
implements NodeIterator<T> {
    private final NodeNavigator<T> navigator;
    private final T rootNode;
    private T currentNode;
    private T nextNode;
    private final int maxDepth;
    protected Logger logger;

    public NodePreOrderIterator(T t) {
        this(t, -1);
    }

    public NodePreOrderIterator(T t, int n) {
        this.rootNode = t;
        this.navigator = new NodeNavigator<T>(t);
        this.maxDepth = n;
        this.nextNode = t;
        this.currentNode = null;
        this.logger = LoggerFactory.getLogger(NodePreOrderIterator.class);
    }

    @Override
    public boolean hasNext() {
        return this.nextNode != null;
    }

    @Override
    public T next() {
        if (this.nextNode != null) {
            this.currentNode = this.navigator.getCurrentNode();
            this.nextNode();
            return this.currentNode;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDepth() {
        return NodeUtils.getDepthToPseudoRoot(this.currentNode, this.rootNode);
    }

    private void nextNode() {
        if (!this.navigator.hasChildren() && !this.navigator.hasParent()) {
            this.logger.debug("detected single-node tree");
            this.nextNode = null;
        } else if (this.navigator.hasChildren() && this.isDepthInValidRange()) {
            this.logger.debug("node has children and current depth is in valid range");
            this.navigator.navigateToChild();
        } else if (this.navigator.hasSiblingsToRight()) {
            this.navigator.navigateToSibling();
        } else {
            this.navigator.navigateToParentNextSibling();
            if (this.navigator.isAtRoot()) {
                this.nextNode = null;
            }
        }
    }

    private boolean isDepthInValidRange() {
        return this.maxDepth == -1 || this.navigator.getDepth() <= this.maxDepth;
    }
}

