/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.node.iterator.fast;

import com.ibm.arcs.basic.node.Node;
import com.ibm.arcs.basic.node.NodeUtils;
import com.ibm.arcs.basic.node.iterator.NodeIterator;
import java.util.ArrayList;
import java.util.Iterator;

public class NodePreOrderIteratorFast<T extends Node<T>>
implements NodeIterator<T> {
    private final T rootNode;
    private T currentNode;
    private final ArrayList<T> entries = new ArrayList();
    private Iterator<T> entriesIterator;
    private final int maxDepth;

    public NodePreOrderIteratorFast(T t) {
        this(t, -1);
    }

    public NodePreOrderIteratorFast(T t, int n) {
        this.rootNode = t;
        this.currentNode = null;
        this.maxDepth = n;
        this.buildEntriesList();
        this.entriesIterator = this.entries.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.entriesIterator.hasNext();
    }

    @Override
    public T next() {
        this.currentNode = (Node)this.entriesIterator.next();
        return this.currentNode;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDepth() {
        return NodeUtils.getDepthToPseudoRoot(this.currentNode, this.rootNode);
    }

    private void buildEntriesList() {
        this.buildEntriesListRecursive(this.rootNode, 0);
    }

    private void buildEntriesListRecursive(T t, int n) {
        this.entries.add(t);
        if (t.hasChildren() && (n <= this.maxDepth || this.maxDepth == -1)) {
            for (Node node : t.getChildren()) {
                this.buildEntriesListRecursive(node, n + 1);
            }
        }
    }
}

