/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.number;

public class NaturalNumber
implements Comparable<NaturalNumber> {
    public final Integer value;
    public static final NaturalNumber ONE = new NaturalNumber(1);

    public NaturalNumber(Integer n) {
        if (!NaturalNumber.isNaturalNumber(n)) {
            throw new IllegalArgumentException(n + " is not a natural number");
        }
        this.value = n;
    }

    public static boolean isNaturalNumber(Integer n) {
        return n >= 1;
    }

    public static NaturalNumber valueOf(String string) {
        Integer n = Integer.parseInt(string);
        return new NaturalNumber(n);
    }

    public Integer toInteger() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.value == null ? 0 : this.value.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!(object instanceof NaturalNumber)) {
            return false;
        }
        NaturalNumber naturalNumber = (NaturalNumber)object;
        return !(this.value == null ? naturalNumber.value != null : !this.value.equals(naturalNumber.value));
    }

    @Override
    public int compareTo(NaturalNumber naturalNumber) {
        if (this == naturalNumber) {
            return 0;
        }
        return this.value.compareTo(naturalNumber.value);
    }
}

