/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.number;

import com.ibm.arcs.basic.number.BuildDateQualifier;
import com.ibm.arcs.basic.number.WholeNumber;

public class Version
implements Comparable<Version> {
    public final WholeNumber major;
    public final WholeNumber minor;
    public final WholeNumber service;
    public final BuildDateQualifier qualifier;

    public Version(Integer n, Integer n2, Integer n3) {
        this.major = new WholeNumber(n);
        this.minor = new WholeNumber(n2);
        this.service = new WholeNumber(n3);
        this.qualifier = new BuildDateQualifier();
    }

    public Version(Integer n, Integer n2, Integer n3, BuildDateQualifier buildDateQualifier) {
        this.major = new WholeNumber(n);
        this.minor = new WholeNumber(n2);
        this.service = new WholeNumber(n3);
        this.qualifier = buildDateQualifier;
    }

    public Version(WholeNumber wholeNumber, WholeNumber wholeNumber2, WholeNumber wholeNumber3, BuildDateQualifier buildDateQualifier) {
        this.major = wholeNumber;
        this.minor = wholeNumber2;
        this.service = wholeNumber3;
        this.qualifier = buildDateQualifier;
    }

    public Version(Version version) {
        this.major = new WholeNumber(version.major);
        this.minor = new WholeNumber(version.minor);
        this.service = new WholeNumber(version.service);
        this.qualifier = new BuildDateQualifier(version.qualifier);
    }

    public Integer getMajor() {
        return this.major.toInteger();
    }

    public Integer getMinor() {
        return this.minor.toInteger();
    }

    public Integer getService() {
        return this.service.toInteger();
    }

    public String getQualifier() {
        return this.qualifier.toString();
    }

    public Version incrementMajor() {
        int n = this.major.toInteger() + 1;
        int n2 = 0;
        int n3 = 0;
        return new Version(n, n2, n3);
    }

    public Version incrementMinor() {
        int n = this.minor.toInteger() + 1;
        int n2 = 0;
        return new Version(this.major.toInteger(), n, n2);
    }

    public Version updateBuildDateQualifier() {
        return new Version(this.major, this.minor, this.service, new BuildDateQualifier());
    }

    @Override
    public int compareTo(Version version) {
        if (this == version) {
            return 0;
        }
        int n = this.major.compareTo(version.major);
        int n2 = this.minor.compareTo(version.minor);
        int n3 = this.service.compareTo(version.service);
        int n4 = this.qualifier.compareTo(version.qualifier);
        if (n <= 0 && n2 <= 0 && n3 <= 0 && n4 <= 0) {
            if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
                return 0;
            }
            return -1;
        }
        return 1;
    }
}

