/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.number;

public class WholeNumber
implements Comparable<WholeNumber> {
    public final Integer value;
    public static final WholeNumber ZERO = new WholeNumber(0);
    public static final WholeNumber ONE = new WholeNumber(1);

    public WholeNumber(Integer n) {
        if (!WholeNumber.isWholeNumber(n)) {
            throw new IllegalArgumentException(n + " is not a whole number");
        }
        this.value = n;
    }

    public WholeNumber(WholeNumber wholeNumber) {
        this.value = wholeNumber.value;
    }

    public static boolean isWholeNumber(Integer n) {
        return n >= 0;
    }

    public static WholeNumber valueOf(String string) {
        Integer n = Integer.parseInt(string);
        return new WholeNumber(n);
    }

    public Integer toInteger() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.value == null ? 0 : this.value.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!(object instanceof WholeNumber)) {
            return false;
        }
        WholeNumber wholeNumber = (WholeNumber)object;
        return !(this.value == null ? wholeNumber.value != null : !this.value.equals(wholeNumber.value));
    }

    @Override
    public int compareTo(WholeNumber wholeNumber) {
        if (this == wholeNumber) {
            return 0;
        }
        return this.value.compareTo(wholeNumber.value);
    }
}

