/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.parameter;

import com.ibm.arcs.basic.parameter.ImmutableParameter;
import com.ibm.arcs.basic.parameter.Parameter;
import com.ibm.arcs.basic.strings.StringUtils;
import com.ibm.arcs.basic.types.GenericTree;
import com.ibm.arcs.basic.types.GenericTreeNode;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ParameterXML {
    public static GenericTree<Parameter> createGenericTreeFromXmlFile(File file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        GenericTree<Parameter> genericTree = new GenericTree<Parameter>();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        document.getDocumentElement().normalize();
        Element element = document.getDocumentElement();
        GenericTreeNode<Parameter> genericTreeNode = new GenericTreeNode<Parameter>(ParameterXML.convertNodeToParameter(element));
        genericTree.setRoot(genericTreeNode);
        ParameterXML.attachDocumentNodesAsChildrenRecursively(element, genericTreeNode);
        return genericTree;
    }

    public static Parameter convertNodeToParameter(Node node) {
        String string = node.getNodeName();
        Short s = node.getNodeType();
        String string2 = null;
        ImmutableParameter immutableParameter = null;
        if (s == 1) {
            String string3;
            Node node2 = node.getFirstChild();
            if (node2 != null && (string3 = node2.getNodeValue()) != null && (string2 = StringUtils.removeLeadingTrailingSpaces(string3)).length() == 0) {
                string2 = null;
            }
            immutableParameter = new ImmutableParameter(string, string2);
        }
        return immutableParameter;
    }

    private static void attachDocumentNodesAsChildrenRecursively(Node node, GenericTreeNode<Parameter> genericTreeNode) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            Parameter parameter = ParameterXML.convertNodeToParameter(node2);
            if (parameter != null) {
                GenericTreeNode<Parameter> genericTreeNode2 = genericTreeNode.addChild(parameter);
                NodeList nodeList2 = node2.getChildNodes();
                if (nodeList2.getLength() > 0) {
                    ParameterXML.attachDocumentNodesAsChildrenRecursively(node2, genericTreeNode2);
                }
            }
            ++n;
        }
    }

    public static void attachDocumentNodesToGenericTreeNode(Node node, GenericTreeNode<Parameter> genericTreeNode) {
        Parameter parameter = ParameterXML.convertNodeToParameter(node);
        if (parameter != null) {
            GenericTreeNode<Parameter> genericTreeNode2 = genericTreeNode.addChild(parameter);
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                ParameterXML.attachDocumentNodesToGenericTreeNode(node2, genericTreeNode2);
                ++n;
            }
        }
    }

    public static GenericTreeNode<Parameter> convertDocumentNodesToGenericTreeNodes(Node node) {
        GenericTreeNode<Parameter> genericTreeNode = new GenericTreeNode<Parameter>();
        genericTreeNode.setData(ParameterXML.convertNodeToParameter(node));
        return genericTreeNode;
    }
}

