/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.parameter.hierarchical;

import java.io.StringWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class DocumentXmlConverter {
    private boolean indentOutput = true;
    private int indentAmount = 2;

    public void enableIndentedOutput() {
        this.indentOutput = true;
    }

    public void disabledIndentedOutput() {
        this.indentOutput = false;
    }

    public void setIndentAmount(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("amount to indent must be greater than zero");
        }
        this.indentAmount = n;
    }

    public String toString(Document document) throws TransformerException {
        DOMSource dOMSource = new DOMSource(document);
        return this.toString(dOMSource);
    }

    public String toString(Source source) throws TransformerException {
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        Transformer transformer = this.getTransformer();
        transformer.transform(source, streamResult);
        return stringWriter.toString();
    }

    public Transformer getTransformer() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        if (this.indentOutput) {
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(this.indentAmount));
        }
        return transformer;
    }
}

