/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.parameter.hierarchical;

import com.ibm.arcs.basic.node.CycleException;
import com.ibm.arcs.basic.node.IllegalAddException;
import com.ibm.arcs.basic.node.Node;
import com.ibm.arcs.basic.node.NodeManipulation;
import com.ibm.arcs.basic.node.iterator.NodeIterator;
import com.ibm.arcs.basic.node.iterator.compact.NodeLevelOrderIteratorFactory;
import com.ibm.arcs.basic.parameter.ImmutableParameter;
import com.ibm.arcs.basic.parameter.Parameter;
import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameterDocument;
import com.ibm.arcs.basic.strings.IndentString;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;

public final class HierarchicalParameter
extends ImmutableParameter
implements Collection<HierarchicalParameter>,
Node<HierarchicalParameter>,
NodeManipulation<HierarchicalParameter> {
    HierarchicalParameter parent;
    private final ArrayList<Parameter> attributes;
    private final ArrayList<HierarchicalParameter> children;
    private static final String TOSTRING_LABEL = "HierarchicalParameter";

    public HierarchicalParameter(String string) {
        this(string, null, null);
    }

    public HierarchicalParameter(String string, String string2) {
        this(string, string2, null);
    }

    public HierarchicalParameter(String string, HierarchicalParameter hierarchicalParameter) {
        this(string, null, hierarchicalParameter);
    }

    public HierarchicalParameter(String string, String string2, HierarchicalParameter hierarchicalParameter) {
        super(string, string2);
        if (string == null) {
            throw new IllegalArgumentException("Key must be specified for all HierarchicalParameters");
        }
        this.parent = hierarchicalParameter;
        if (hierarchicalParameter != null) {
            hierarchicalParameter.children.add(this);
        }
        this.attributes = new ArrayList(0);
        this.children = new ArrayList(0);
    }

    public HierarchicalParameter(Parameter parameter) {
        this(parameter.getKey(), parameter.getValue());
    }

    public HierarchicalParameter(Parameter parameter, HierarchicalParameter hierarchicalParameter) {
        this(parameter.getKey(), parameter.getValue(), hierarchicalParameter);
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public HierarchicalParameter getParent() {
        return this.parent;
    }

    @Override
    public void setParent(HierarchicalParameter hierarchicalParameter) {
        this.detachFromParent();
        this.attachToParent(hierarchicalParameter);
    }

    @Override
    public void unsetParent() {
        this.detachFromParent();
    }

    @Override
    public void addChild(HierarchicalParameter hierarchicalParameter) {
        HierarchicalParameter.checkCycle(hierarchicalParameter, this);
        hierarchicalParameter.detachFromParent();
        hierarchicalParameter.attachToParent(this);
    }

    private static void checkCycle(HierarchicalParameter hierarchicalParameter, HierarchicalParameter hierarchicalParameter2) throws IllegalAddException {
        if (hierarchicalParameter == hierarchicalParameter2) {
            throw new CycleException("Cannot add a node to itself");
        }
        if (hierarchicalParameter.getNumberOfChildren() == 0) {
            return;
        }
        do {
            if ((hierarchicalParameter2 = hierarchicalParameter2.getParent()) != null) continue;
            return;
        } while (hierarchicalParameter2 != hierarchicalParameter);
        throw new CycleException("Cannot add an ancestor as a child");
    }

    @Override
    public void removeChild(HierarchicalParameter hierarchicalParameter) {
        hierarchicalParameter.detachFromParent();
    }

    private void attachToParent(HierarchicalParameter hierarchicalParameter) {
        this.parent = hierarchicalParameter;
        hierarchicalParameter.children.add(this);
    }

    private void detachFromParent() {
        if (this.parent != null) {
            this.parent.children.remove(this);
            this.parent = null;
        }
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public int getNumberOfChildren() {
        return this.children.size();
    }

    @Override
    public List<HierarchicalParameter> getChildren() {
        return new Vector<HierarchicalParameter>(this.children);
    }

    @Override
    public HierarchicalParameter getChild(int n) {
        if (this.hasChildren()) {
            return this.children.get(n);
        }
        throw new IllegalArgumentException("HierarchicalParameter does not have any children");
    }

    @Override
    public HierarchicalParameter getRoot() {
        if (this.getParent() != null) {
            return this.getRoot();
        }
        return this;
    }

    public void addAttribute(Parameter parameter) {
        this.attributes.add(parameter);
    }

    public void removeAttribute(Parameter parameter) {
        this.attributes.remove(parameter);
    }

    public boolean hasAttributes() {
        return this.attributes.size() > 0;
    }

    public boolean hasAttribute(String string) {
        for (Parameter parameter : this.attributes) {
            if (!parameter.getKey().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public List<Parameter> getAttributes() {
        return new ArrayList<Parameter>(this.attributes);
    }

    public int getNumberOfAttributes() {
        return this.attributes.size();
    }

    public Parameter getAttribute(int n) {
        return this.attributes.get(n);
    }

    public Parameter getAttribute(String string) {
        Parameter parameter = null;
        for (Parameter parameter2 : this.attributes) {
            if (!parameter2.getKey().equalsIgnoreCase(string)) continue;
            parameter = parameter2;
        }
        return parameter;
    }

    public HierarchicalParameter copy() {
        HierarchicalParameter hierarchicalParameter = new HierarchicalParameter(this);
        HierarchicalParameter.copyAttributes(this, hierarchicalParameter);
        return hierarchicalParameter;
    }

    public HierarchicalParameter copyWithNewKey(String string) {
        HierarchicalParameter hierarchicalParameter = new HierarchicalParameter(string, this.getValue());
        HierarchicalParameter.copyAttributes(this, hierarchicalParameter);
        return hierarchicalParameter;
    }

    public HierarchicalParameter copyWithChildrenAndNewKey(String string) {
        HierarchicalParameter hierarchicalParameter = new HierarchicalParameter(string, this.getValue());
        this.copyChildren(hierarchicalParameter);
        return hierarchicalParameter;
    }

    private void copyChildren(HierarchicalParameter hierarchicalParameter) {
        HierarchicalParameter.copyChildren(this, hierarchicalParameter);
    }

    private static void copyChildren(HierarchicalParameter hierarchicalParameter, HierarchicalParameter hierarchicalParameter2) {
        for (HierarchicalParameter hierarchicalParameter3 : hierarchicalParameter.getChildren()) {
            HierarchicalParameter.copyWithChildren(hierarchicalParameter3, hierarchicalParameter2);
        }
    }

    private static HierarchicalParameter copyWithChildren(HierarchicalParameter hierarchicalParameter, HierarchicalParameter hierarchicalParameter2) {
        HierarchicalParameter hierarchicalParameter3 = new HierarchicalParameter(hierarchicalParameter, hierarchicalParameter2);
        HierarchicalParameter.copyAttributes(hierarchicalParameter, hierarchicalParameter3);
        for (HierarchicalParameter hierarchicalParameter4 : hierarchicalParameter.getChildren()) {
            HierarchicalParameter.copyWithChildren(hierarchicalParameter4, hierarchicalParameter3);
        }
        return hierarchicalParameter3;
    }

    public static void copyAttributes(HierarchicalParameter hierarchicalParameter, HierarchicalParameter hierarchicalParameter2) {
        for (Parameter parameter : hierarchicalParameter.getAttributes()) {
            hierarchicalParameter2.addAttribute(parameter);
        }
    }

    public HierarchicalParameter copyWithChildren() {
        return HierarchicalParameter.copyWithChildren(this, null);
    }

    public HierarchicalParameter copyWithChildren(HierarchicalParameter hierarchicalParameter) {
        return HierarchicalParameter.copyWithChildren(this, hierarchicalParameter);
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.print(printWriter);
        printWriter.flush();
        stringWriter.flush();
        String string = stringWriter.toString();
        try {
            printWriter.close();
            stringWriter.close();
        }
        catch (IOException iOException) {}
        return string;
    }

    @Override
    public void print(PrintWriter printWriter) {
        Vector<HierarchicalParameter> vector = new Vector<HierarchicalParameter>(1);
        vector.add(this);
        this.printRecursive(printWriter, vector, 0);
    }

    private void printRecursive(PrintWriter printWriter, List<HierarchicalParameter> list, int n) {
        String string = IndentString.getIndentString(n);
        for (HierarchicalParameter hierarchicalParameter : list) {
            printWriter.print(string);
            printWriter.print(HierarchicalParameter.toString(hierarchicalParameter, TOSTRING_LABEL));
            if (hierarchicalParameter.hasAttributes()) {
                printWriter.print(" (");
                for (Parameter parameter : hierarchicalParameter.getAttributes()) {
                    printWriter.print(String.valueOf(parameter.getKey()) + "=\"" + parameter.getValue() + "\"");
                }
                printWriter.print(")");
            }
            printWriter.println();
            this.printRecursive(printWriter, hierarchicalParameter.getChildren(), n + 1);
        }
    }

    public Document convertToDocument() {
        return HierarchicalParameterDocument.convertToDocument(this);
    }

    public static HierarchicalParameter readFromDocument(Document document) {
        return HierarchicalParameterDocument.readFromDocument(document);
    }

    @Override
    public final boolean add(HierarchicalParameter hierarchicalParameter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean addAll(Collection<? extends HierarchicalParameter> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object object) {
        NodeIterator<HierarchicalParameter> nodeIterator = new NodeLevelOrderIteratorFactory<HierarchicalParameter>().create(this);
        if (object != null) {
            while (nodeIterator.hasNext()) {
                if (!((HierarchicalParameter)nodeIterator.next()).equals(object)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<HierarchicalParameter> iterator() {
        return new NodeLevelOrderIteratorFactory<HierarchicalParameter>().create(this);
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int n = 1;
        for (HierarchicalParameter hierarchicalParameter : this.children) {
            n += hierarchicalParameter.size();
        }
        return n;
    }

    @Override
    public Object[] toArray() {
        HierarchicalParameter hierarchicalParameter;
        ArrayList<HierarchicalParameter> arrayList = new ArrayList<HierarchicalParameter>();
        NodeIterator<HierarchicalParameter> nodeIterator = new NodeLevelOrderIteratorFactory<HierarchicalParameter>().create(this);
        while ((hierarchicalParameter = (HierarchicalParameter)nodeIterator.next()) != null) {
            arrayList.add(hierarchicalParameter);
        }
        return arrayList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        HierarchicalParameter hierarchicalParameter;
        ArrayList<HierarchicalParameter> arrayList = new ArrayList<HierarchicalParameter>();
        NodeIterator<HierarchicalParameter> nodeIterator = new NodeLevelOrderIteratorFactory<HierarchicalParameter>().create(this);
        while ((hierarchicalParameter = (HierarchicalParameter)nodeIterator.next()) != null) {
            arrayList.add(hierarchicalParameter);
        }
        return arrayList.toArray((Object[])Array.newInstance(TArray.getClass().getComponentType(), this.size()));
    }
}

