/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.parameter.hierarchical;

import com.ibm.arcs.basic.parameter.ImmutableParameter;
import com.ibm.arcs.basic.parameter.Parameter;
import com.ibm.arcs.basic.parameter.ParameterXML;
import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HierarchicalParameterDocument {
    public static Document convertToDocument(HierarchicalParameter hierarchicalParameter) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            HierarchicalParameterDocument.convertToDocumentRecursive(document, null, hierarchicalParameter);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("Unable to convert to document", parserConfigurationException);
        }
        return document;
    }

    private static void convertToDocumentRecursive(Document document, Node node, HierarchicalParameter hierarchicalParameter) {
        Element element = document.createElement(hierarchicalParameter.getKey());
        if (hierarchicalParameter.getValue() != null) {
            element.appendChild(document.createTextNode(hierarchicalParameter.getValue()));
        }
        for (Parameter parameter : hierarchicalParameter.getAttributes()) {
            element.setAttribute(parameter.getKey(), parameter.getValue());
        }
        if (node == null) {
            document.appendChild(element);
        } else {
            node.appendChild(element);
        }
        for (HierarchicalParameter hierarchicalParameter2 : hierarchicalParameter.getChildren()) {
            HierarchicalParameterDocument.convertToDocumentRecursive(document, element, hierarchicalParameter2);
        }
    }

    public static HierarchicalParameter readFromDocument(Document document) {
        HierarchicalParameter hierarchicalParameter = null;
        document.getDocumentElement().normalize();
        Element element = document.getDocumentElement();
        hierarchicalParameter = new HierarchicalParameter(ParameterXML.convertNodeToParameter(element), null);
        HierarchicalParameterDocument.readFromDocumentRecursive(element, hierarchicalParameter);
        return hierarchicalParameter;
    }

    private static void readFromDocumentRecursive(Node node, HierarchicalParameter hierarchicalParameter) {
        HierarchicalParameterDocument.extractNodeAttributes(node, hierarchicalParameter);
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            Parameter parameter = ParameterXML.convertNodeToParameter(node2);
            if (parameter != null) {
                HierarchicalParameter hierarchicalParameter2 = new HierarchicalParameter(parameter, hierarchicalParameter);
                HierarchicalParameterDocument.readFromDocumentRecursive(node2, hierarchicalParameter2);
            }
            ++n;
        }
    }

    private static void extractNodeAttributes(Node node, HierarchicalParameter hierarchicalParameter) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Node node2 = namedNodeMap.item(n);
                ImmutableParameter immutableParameter = new ImmutableParameter(node2.getNodeName(), node2.getNodeValue());
                hierarchicalParameter.addAttribute(immutableParameter);
                ++n;
            }
        }
    }
}

