/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.parameter.hierarchical;

import com.ibm.arcs.basic.node.NodeSearch;
import com.ibm.arcs.basic.node.NodeSearcher;
import com.ibm.arcs.basic.node.NodeSearches;
import com.ibm.arcs.basic.node.iterator.compact.NodeLevelOrderIteratorFactory;
import com.ibm.arcs.basic.parameter.Parameter;
import com.ibm.arcs.basic.parameter.ParameterMatcher;
import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.basic.parameter.hierarchical.matcher.HierarchicalParameterKeyMatcher;
import com.ibm.arcs.basic.parameter.hierarchical.matcher.HierarchicalParameterMatcher;
import com.ibm.arcs.basic.strings.IStringMatcher;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;

public class HierarchicalParameterSearches {
    public static NodeSearch<HierarchicalParameter> getAllMatchingKeysSearch(IStringMatcher iStringMatcher) {
        NodeSearcher<HierarchicalParameter> nodeSearcher = new NodeSearcher<HierarchicalParameter>(new NodeLevelOrderIteratorFactory(), new HierarchicalParameterKeyMatcher(iStringMatcher));
        return nodeSearcher;
    }

    public static List<HierarchicalParameter> getAllMatchingKeys(HierarchicalParameter hierarchicalParameter, IStringMatcher iStringMatcher) {
        return HierarchicalParameterSearches.getAllMatchingKeysSearch(iStringMatcher).search(hierarchicalParameter);
    }

    public static NodeSearch<HierarchicalParameter> getAllMatchingKeysSearch(IStringMatcher iStringMatcher, int n) {
        return NodeSearches.getAllMatchingSearch(new HierarchicalParameterKeyMatcher(iStringMatcher), n);
    }

    public static List<HierarchicalParameter> getAllMatchingKeys(HierarchicalParameter hierarchicalParameter, IStringMatcher iStringMatcher, int n) {
        return HierarchicalParameterSearches.getAllMatchingKeysSearch(iStringMatcher, n).search(hierarchicalParameter);
    }

    public static Set<Parameter> getAttribute(ParameterMatcher parameterMatcher, HierarchicalParameter hierarchicalParameter) {
        HashSet<Parameter> hashSet = new HashSet<Parameter>();
        for (Parameter parameter : hierarchicalParameter.getAttributes()) {
            if (!parameterMatcher.matches(parameter)) continue;
            hashSet.add(parameter);
        }
        return hashSet;
    }

    public static String getValueOfMatchingChild(HierarchicalParameter hierarchicalParameter, HierarchicalParameterMatcher hierarchicalParameterMatcher) {
        NodeSearcher<HierarchicalParameter> nodeSearcher = new NodeSearcher<HierarchicalParameter>(new NodeLevelOrderIteratorFactory(), hierarchicalParameterMatcher);
        nodeSearcher.setMaxDepth(1);
        List<HierarchicalParameter> list = nodeSearcher.search(hierarchicalParameter);
        if (list.size() == 0) {
            throw new RuntimeException("no results found for search");
        }
        if (list.size() > 1) {
            throw new RuntimeException("too many results found for search");
        }
        return list.get(0).getValue();
    }

    public static HierarchicalParameter getFirstMatchingKey(HierarchicalParameter hierarchicalParameter, IStringMatcher iStringMatcher) throws CoreException {
        return NodeSearches.getFirstMatching(hierarchicalParameter, new HierarchicalParameterKeyMatcher(iStringMatcher));
    }
}

