/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.parameter.hierarchical;

import com.ibm.arcs.basic.parameter.hierarchical.DocumentXmlConverter;
import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.basic.parameter.hierarchical.IHierarchicalParameterXmlConverter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HierarchicalParameterXmlConverter
implements IHierarchicalParameterXmlConverter {
    private static IHierarchicalParameterXmlConverter sharedInstance = null;
    private static final Object sharedInstanceLock = new Object();
    DocumentXmlConverter documentConverter = new DocumentXmlConverter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IHierarchicalParameterXmlConverter getSharedInstance() {
        Object object = sharedInstanceLock;
        synchronized (object) {
            if (sharedInstance == null) {
                sharedInstance = new HierarchicalParameterXmlConverter();
            }
        }
        return sharedInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSharedInstance(IHierarchicalParameterXmlConverter iHierarchicalParameterXmlConverter) {
        Object object = sharedInstanceLock;
        synchronized (object) {
            sharedInstance = iHierarchicalParameterXmlConverter;
        }
    }

    public void enableIndentedOutput() {
        this.documentConverter.enableIndentedOutput();
    }

    public void disableIndentedOutput() {
        this.documentConverter.disabledIndentedOutput();
    }

    public void setIndentAmount(int n) {
        this.documentConverter.setIndentAmount(n);
    }

    @Override
    public String toString(HierarchicalParameter hierarchicalParameter) throws CoreException {
        try {
            Source source = HierarchicalParameterXmlConverter.convertToSource(hierarchicalParameter);
            return this.documentConverter.toString(source);
        }
        catch (TransformerException transformerException) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.basic", "unable to convert specified hierarchical parameter to string representation", (Throwable)transformerException));
        }
    }

    private static final Source convertToSource(HierarchicalParameter hierarchicalParameter) {
        Document document = hierarchicalParameter.convertToDocument();
        DOMSource dOMSource = new DOMSource(document);
        return dOMSource;
    }

    @Override
    public void writeToFile(HierarchicalParameter hierarchicalParameter, File file) throws CoreException {
        try {
            Source source = HierarchicalParameterXmlConverter.convertToSource(hierarchicalParameter);
            StreamResult streamResult = new StreamResult(file);
            Transformer transformer = this.documentConverter.getTransformer();
            transformer.transform(source, streamResult);
        }
        catch (TransformerException transformerException) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.basic", "unable to output specified hierarchical parameter to file", (Throwable)transformerException));
        }
    }

    @Override
    public void writeToWriter(HierarchicalParameter hierarchicalParameter, Writer writer) throws CoreException {
        try {
            Source source = HierarchicalParameterXmlConverter.convertToSource(hierarchicalParameter);
            StreamResult streamResult = new StreamResult(writer);
            Transformer transformer = this.documentConverter.getTransformer();
            transformer.transform(source, streamResult);
        }
        catch (TransformerException transformerException) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.basic", "unable to output specified hierarchical parameter to writer", (Throwable)transformerException));
        }
    }

    @Override
    public HierarchicalParameter read(InputStream inputStream) throws CoreException {
        InputSource inputSource = new InputSource();
        inputSource.setByteStream(inputStream);
        Document document = HierarchicalParameterXmlConverter.readDocument(inputSource);
        return HierarchicalParameterXmlConverter.convertToHierarchicalParameter(document);
    }

    @Override
    public HierarchicalParameter read(InputSource inputSource) throws CoreException {
        Document document = HierarchicalParameterXmlConverter.readDocument(inputSource);
        return HierarchicalParameterXmlConverter.convertToHierarchicalParameter(document);
    }

    @Override
    public HierarchicalParameter read(String string) throws CoreException {
        try {
            StringReader stringReader = new StringReader(string);
            InputSource inputSource = new InputSource(stringReader);
            Document document = HierarchicalParameterXmlConverter.readDocument(inputSource);
            return HierarchicalParameterXmlConverter.convertToHierarchicalParameter(document);
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.basic", "unable to read HierarchicalParameter from String", (Throwable)exception));
        }
    }

    @Override
    public HierarchicalParameter read(File file) throws CoreException {
        try {
            DocumentBuilder documentBuilder = HierarchicalParameterXmlConverter.getDocumentBuilder();
            Document document = documentBuilder.parse(file);
            return HierarchicalParameterXmlConverter.convertToHierarchicalParameter(document);
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.basic", "unable to read HierarchicalParameter from File", (Throwable)exception));
        }
    }

    private static final DocumentBuilder getDocumentBuilder() throws CoreException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.basic", "Unable to create a suitable DocumentBuilder", (Throwable)parserConfigurationException));
        }
    }

    private static final Document readDocument(InputSource inputSource) throws CoreException {
        DocumentBuilder documentBuilder = HierarchicalParameterXmlConverter.getDocumentBuilder();
        try {
            Document document = documentBuilder.parse(inputSource);
            return document;
        }
        catch (SAXException sAXException) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.basic", "unable to parse HierarchicalParameter", (Throwable)sAXException));
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.basic", "IOException while parsing HierarchicalParameter", (Throwable)iOException));
        }
    }

    private static final HierarchicalParameter convertToHierarchicalParameter(Document document) {
        document.getDocumentElement().normalize();
        HierarchicalParameter hierarchicalParameter = HierarchicalParameter.readFromDocument(document);
        return hierarchicalParameter;
    }

    public static boolean validateXmlFile(File file, File file2) throws SAXException, IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(file2);
        StreamSource streamSource = new StreamSource(file);
        return HierarchicalParameterXmlConverter.validateXml(streamSource, schema);
    }

    public static boolean validateXmlStream(InputStream inputStream, InputStream inputStream2) throws SAXException, IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(inputStream2));
        StreamSource streamSource = new StreamSource(inputStream);
        return HierarchicalParameterXmlConverter.validateXml(streamSource, schema);
    }

    private static boolean validateXml(Source source, Schema schema) throws SAXException, IOException {
        Validator validator = schema.newValidator();
        try {
            validator.validate(source);
            return true;
        }
        catch (SAXException sAXException) {
            return false;
        }
    }
}

