/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.parameter.hierarchical.matcher;

import com.ibm.arcs.basic.parameter.Parameter;
import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.basic.parameter.hierarchical.matcher.HierarchicalParameterMatcher;
import com.ibm.arcs.basic.strings.IStringMatcher;
import com.ibm.arcs.basic.strings.StringMatcherExact;
import java.util.ArrayList;
import java.util.List;

public class HierarchicalParameterAttributeMatcher
implements HierarchicalParameterMatcher {
    IStringMatcher nameMatcher;
    IStringMatcher valueMatcher;

    public HierarchicalParameterAttributeMatcher(IStringMatcher iStringMatcher, IStringMatcher iStringMatcher2) {
        this.nameMatcher = iStringMatcher;
        this.valueMatcher = iStringMatcher2;
    }

    public HierarchicalParameterAttributeMatcher(Parameter parameter) {
        this.nameMatcher = new StringMatcherExact(parameter.getKey());
        this.valueMatcher = new StringMatcherExact(parameter.getValue());
    }

    @Override
    public boolean matches(HierarchicalParameter hierarchicalParameter) {
        for (Parameter parameter : hierarchicalParameter.getAttributes()) {
            if (!this.nameMatcher.matches(parameter.getKey()) || !this.valueMatcher.matches(parameter.getValue())) continue;
            return true;
        }
        return false;
    }

    public List<String> getMatchingValues(HierarchicalParameter hierarchicalParameter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Parameter parameter : hierarchicalParameter.getAttributes()) {
            if (!this.nameMatcher.matches(parameter.getKey()) || !this.valueMatcher.matches(parameter.getValue())) continue;
            arrayList.add(parameter.getValue());
        }
        return arrayList;
    }
}

