/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.strings;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class StringInputStreamUtils {
    private static final String defaultFileEncoding = System.getProperty("file.encoding");

    public static final String toString(InputStream inputStream) throws IOException {
        return StringInputStreamUtils.toString(inputStream, defaultFileEncoding);
    }

    public static final String toString(InputStream inputStream, String string) throws IOException {
        char[] cArray;
        StringWriter stringWriter = new StringWriter();
        try {
            int n;
            cArray = new char[1024];
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((n = bufferedReader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n);
            }
            String string2 = stringWriter.toString();
            return string2;
        }
        finally {
            inputStream.close();
            cArray = null;
        }
    }

    public static final InputStream toInputStream(String string) {
        if (defaultFileEncoding != null) {
            return StringInputStreamUtils.toInputStream(string, defaultFileEncoding);
        }
        throw new RuntimeException("no default file encoding exists for the current runtime environment");
    }

    public static final InputStream toInputStream(String string, String string2) {
        ByteBuffer byteBuffer = Charset.forName(string2).encode(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteBuffer.array(), 0, byteBuffer.limit());
        return byteArrayInputStream;
    }
}

