/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.strings;

import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;

public final class StringUtils {
    public static String removeLeadingSpaces(String string) {
        return string.replaceAll("^\\s+", "");
    }

    public static String removeTrailingSpaces(String string) {
        return string.replaceAll("\\s+$", "");
    }

    public static String reduceInnerSpaces(String string) {
        return string.replaceAll("\\b\\s{2,}\\b", " ");
    }

    public static String removeExtraneousSpaces(String string) {
        return StringUtils.reduceInnerSpaces(StringUtils.removeLeadingSpaces(StringUtils.removeTrailingSpaces(string)));
    }

    public static String removeAllSpaces(String string) {
        return string.replaceAll("\\s", "");
    }

    public static String removeLeadingTrailingSpaces(String string) {
        return StringUtils.removeLeadingSpaces(StringUtils.removeTrailingSpaces(string));
    }

    public static String removeNewlines(String string) {
        return string.replaceAll("^\\n", "");
    }

    public static String encloseInDoubleQuotes(String string) {
        return "\"" + string + "\"";
    }

    public static String encloseInSingleQuotes(String string) {
        return "'" + string + "'";
    }

    public static String delimitArgsWithCommas(String ... stringArray) {
        String string = stringArray[0];
        int n = 1;
        while (n < stringArray.length) {
            string = String.valueOf(string) + "," + stringArray[n];
            ++n;
        }
        return string;
    }

    public static String delimit(Collection<String> collection, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String[] splitAtBreaks(String string) {
        Pattern pattern = Pattern.compile("[,\\s]+");
        String[] stringArray = pattern.split(string);
        return stringArray;
    }

    public static String[] splitAtDelimiter(String string, char c) {
        Pattern pattern = Pattern.compile("[" + c + "]+");
        String[] stringArray = pattern.split(string);
        return stringArray;
    }

    public static boolean containsSpaces(String string) {
        return string.indexOf(32) >= 0;
    }

    public static boolean containsAllDigits(String string) {
        return string.matches("[0-9]+");
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() > 0;
    }
}

