/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.tuple;

import com.ibm.arcs.basic.tuple.Pair;
import com.ibm.arcs.basic.tuple.Pairs;

public class ImmutablePair<T1, T2>
implements Pair<T1, T2> {
    private static final String TOSTRING_LABEL = "ImmutablePair";
    private final T1 first;
    private final T2 second;
    private final transient int hashcode;

    public ImmutablePair(T1 T1, T2 T2) {
        this.first = T1;
        this.second = T2;
        this.hashcode = (T1 == null ? 0 : T1.hashCode()) * 31 + (T2 == null ? 0 : T2.hashCode());
    }

    public ImmutablePair(Pair<T1, T2> pair) {
        this.first = pair.getFirst();
        this.second = pair.getSecond();
        this.hashcode = pair.hashCode();
    }

    @Override
    public T1 getFirst() {
        return this.first;
    }

    @Override
    public T2 getSecond() {
        return this.second;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof ImmutablePair)) {
            return false;
        }
        ImmutablePair immutablePair = (ImmutablePair)object;
        return this.equalFirst(immutablePair.first) && this.equalSecond(immutablePair.second);
    }

    private boolean equalFirst(Object object) {
        return this.first == null ? object == null : this.first.equals(object);
    }

    private final boolean equalSecond(Object object) {
        return this.second == null ? object == null : this.second.equals(object);
    }

    public String toString() {
        return Pairs.toString(this, TOSTRING_LABEL);
    }
}

