/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.tuple;

import com.ibm.arcs.basic.tuple.ImmutablePair;
import com.ibm.arcs.basic.tuple.Pair;
import com.ibm.arcs.basic.tuple.Pairs;

public class MutablePair<T1, T2>
implements Pair<T1, T2> {
    private static final String TOSTRING_LABEL = "ImmutablePair";
    private T1 first;
    private T2 second;

    public MutablePair(T1 T1, T2 T2) {
        this.first = T1;
        this.second = T2;
    }

    @Override
    public T1 getFirst() {
        return this.first;
    }

    @Override
    public T2 getSecond() {
        return this.second;
    }

    public void setFirst(T1 T1) {
        this.first = T1;
    }

    public void setSecond(T2 T2) {
        this.second = T2;
    }

    public int hashCode() {
        return (this.first == null ? 0 : this.first.hashCode()) * 31 + (this.second == null ? 0 : this.second.hashCode());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof Pair)) {
            return false;
        }
        Pair pair = (Pair)object;
        return this.firstEquals(pair.getFirst()) && this.secondEquals(pair.getSecond());
    }

    private boolean firstEquals(Object object) {
        if (this.first == null & object == null) {
            return true;
        }
        if (this.first == null ^ object == null) {
            return false;
        }
        return this.first.equals(object);
    }

    private boolean secondEquals(Object object) {
        if (this.second == null & object == null) {
            return true;
        }
        if (this.second == null ^ object == null) {
            return false;
        }
        return this.second.equals(object);
    }

    public ImmutablePair<T1, T2> getFinalizedPair() {
        return new ImmutablePair<T1, T2>(this.getFirst(), this.getSecond());
    }

    public String toString() {
        return Pairs.toString(this, TOSTRING_LABEL);
    }
}

