/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.tuple;

public class Triple<T1, T2, T3> {
    private final T1 first;
    private final T2 second;
    private final T3 third;
    private final transient int hashcode;

    public Triple(T1 T1, T2 T2, T3 T3) {
        this.first = T1;
        this.second = T2;
        this.third = T3;
        this.hashcode = this.generateHashCode();
    }

    public T1 getFirst() {
        return this.first;
    }

    public T2 getSecond() {
        return this.second;
    }

    public T3 getThird() {
        return this.third;
    }

    public int hashCode() {
        return this.hashcode;
    }

    private int generateHashCode() {
        int n = 1;
        n = 31 * n + (this.first == null ? 0 : this.first.hashCode());
        n = 31 * n + (this.second == null ? 0 : this.second.hashCode());
        n = 31 * n + (this.third == null ? 0 : this.third.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Triple)) {
            return false;
        }
        Triple triple = (Triple)object;
        return this.equalFirst(triple.first) && this.equalSecond(triple.second) && this.equalThird(triple.third);
    }

    private boolean equalFirst(Object object) {
        return this.first == null ? object == null : this.first.equals(object);
    }

    private final boolean equalSecond(Object object) {
        return this.second == null ? object == null : this.second.equals(object);
    }

    private final boolean equalThird(Object object) {
        return this.third == null ? object == null : this.third.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Triple<");
        stringBuffer.append(this.first.getClass().getName());
        stringBuffer.append(',');
        stringBuffer.append(this.second.getClass().getName());
        stringBuffer.append(',');
        stringBuffer.append(this.third.getClass().getName());
        stringBuffer.append(">(");
        stringBuffer.append(this.first.toString());
        stringBuffer.append(',');
        stringBuffer.append(this.second.toString());
        stringBuffer.append(',');
        stringBuffer.append(this.third.toString());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

