/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.tuple.list;

import com.ibm.arcs.basic.tuple.ImmutablePair;
import com.ibm.arcs.basic.tuple.Pair;
import com.ibm.arcs.basic.tuple.list.PairList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class PairArrayList<K, V>
implements PairList<K, V> {
    private final List<Pair<K, V>> pairs = new ArrayList<Pair<K, V>>();

    @Override
    public void clear() {
        this.pairs.clear();
    }

    @Override
    public boolean add(Pair<K, V> pair) {
        return this.pairs.add(pair);
    }

    @Override
    public boolean add(K k, V v) {
        return this.add((Pair<K, V>)new ImmutablePair<K, V>(k, v));
    }

    @Override
    public void add(int n, Pair<K, V> pair) {
        this.pairs.add(n, pair);
    }

    @Override
    public boolean addAll(Collection<? extends Pair<K, V>> collection) {
        return this.pairs.addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends Pair<K, V>> collection) {
        return this.pairs.addAll(n, collection);
    }

    @Override
    public Pair<K, V> set(int n, Pair<K, V> pair) {
        return this.pairs.set(n, pair);
    }

    @Override
    public boolean remove(Object object) {
        return this.pairs.remove(object);
    }

    @Override
    public Pair<K, V> remove(int n) {
        return this.pairs.remove(n);
    }

    @Override
    public void removeKey(K k) {
        Iterator<Pair<K, V>> iterator = this.pairs.iterator();
        Pair<K, V> pair = null;
        while (iterator.hasNext()) {
            pair = iterator.next();
            if (!pair.getFirst().equals(k)) continue;
            iterator.remove();
        }
    }

    @Override
    public void removeValue(V v) {
        Iterator<Pair<K, V>> iterator = this.pairs.iterator();
        Pair<K, V> pair = null;
        while (iterator.hasNext()) {
            pair = iterator.next();
            if (!pair.getSecond().equals(v)) continue;
            iterator.remove();
        }
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.pairs.remove(collection);
    }

    @Override
    public Pair<K, V> get(int n) {
        return this.pairs.get(n);
    }

    @Override
    public Set<V> getValues(K k) {
        HashSet<V> hashSet = new HashSet<V>();
        for (Pair<K, V> pair : this.pairs) {
            if (!pair.getFirst().equals(k)) continue;
            hashSet.add(pair.getSecond());
        }
        return hashSet;
    }

    @Override
    public Set<K> getKeys(V v) {
        HashSet<K> hashSet = new HashSet<K>();
        for (Pair<K, V> pair : this.pairs) {
            if (!pair.getSecond().equals(v)) continue;
            hashSet.add(pair.getFirst());
        }
        return hashSet;
    }

    @Override
    public List<K> getKeys() {
        ArrayList<K> arrayList = new ArrayList<K>();
        for (Pair<K, V> pair : this.pairs) {
            arrayList.add(pair.getFirst());
        }
        return arrayList;
    }

    @Override
    public List<V> getValues() {
        ArrayList<V> arrayList = new ArrayList<V>();
        for (Pair<K, V> pair : this.pairs) {
            arrayList.add(pair.getSecond());
        }
        return arrayList;
    }

    @Override
    public int indexOf(Object object) {
        return this.pairs.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.pairs.lastIndexOf(object);
    }

    @Override
    public int indexOfKey(K k) {
        int n = 0;
        while (n < this.pairs.size()) {
            if (this.pairs.get(n).getFirst().equals(k)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int indexOfValue(V v) {
        int n = 0;
        while (n < this.pairs.size()) {
            if (this.pairs.get(n).getSecond().equals(v)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public Iterator<Pair<K, V>> iterator() {
        return this.pairs.iterator();
    }

    @Override
    public ListIterator<Pair<K, V>> listIterator() {
        return this.pairs.listIterator();
    }

    @Override
    public ListIterator<Pair<K, V>> listIterator(int n) {
        return this.pairs.listIterator(n);
    }

    @Override
    public PairList<K, V> subList(int n, int n2) {
        return (PairList)this.pairs.subList(n, n2);
    }

    @Override
    public boolean containsKey(K k) {
        for (Pair<K, V> pair : this.pairs) {
            if (!pair.getFirst().equals(k)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(V v) {
        for (Pair<K, V> pair : this.pairs) {
            if (!pair.getSecond().equals(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.pairs.size();
    }

    @Override
    public boolean isEmpty() {
        return this.pairs.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.pairs.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.pairs.toArray(TArray);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.pairs.retainAll(collection);
    }

    @Override
    public boolean contains(Object object) {
        return this.pairs.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.pairs.containsAll(collection);
    }
}

