/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.types;

import com.ibm.arcs.basic.types.GenericMatcher;
import com.ibm.arcs.basic.types.GenericMatcherTreeNodeAdapter;
import java.util.Vector;

public class GenericTreeNode<T> {
    private T data;
    private Vector<GenericTreeNode<T>> children = new Vector();

    public GenericTreeNode() {
    }

    public GenericTreeNode(T t) {
        this();
        this.data = t;
    }

    public synchronized T getData() {
        return this.data;
    }

    public synchronized void setData(T t) {
        this.data = t;
    }

    public synchronized boolean hasChildren() {
        return this.children.size() > 0;
    }

    public synchronized Vector<GenericTreeNode<T>> getChildren() {
        return this.children;
    }

    public synchronized GenericTreeNode<T> addChild(T t) {
        GenericTreeNode<T> genericTreeNode = new GenericTreeNode<T>(t);
        this.children.add(genericTreeNode);
        return genericTreeNode;
    }

    public synchronized void addChild(GenericTreeNode<T> genericTreeNode) {
        this.children.add(genericTreeNode);
    }

    public synchronized void removeChild(GenericTreeNode<T> genericTreeNode) {
        this.children.remove(genericTreeNode);
    }

    public synchronized void setChildren(Vector<GenericTreeNode<T>> vector) {
        this.children = vector;
    }

    public synchronized void clearChildren() {
        this.children.clear();
    }

    public Vector<GenericTreeNode<T>> findMatchesDepthFirst(GenericMatcher<T> genericMatcher) {
        Vector<GenericTreeNode<T>> vector = new Vector<GenericTreeNode<T>>();
        this.findMatchesDepthFirst(new GenericMatcherTreeNodeAdapter<T>(genericMatcher), this, vector);
        return vector;
    }

    private void findMatchesDepthFirst(GenericMatcher<GenericTreeNode<T>> genericMatcher, GenericTreeNode<T> genericTreeNode, Vector<GenericTreeNode<T>> vector) {
        if (genericMatcher.matches(genericTreeNode)) {
            vector.add(genericTreeNode);
        }
        if (genericTreeNode.hasChildren()) {
            for (GenericTreeNode<T> genericTreeNode2 : genericTreeNode.children) {
                this.findMatchesDepthFirst(genericMatcher, genericTreeNode2, vector);
            }
        }
    }

    public Vector<GenericTreeNode<T>> findMatchesBreadthFirst(GenericMatcher<T> genericMatcher) {
        Vector<GenericTreeNode<T>> vector = new Vector<GenericTreeNode<T>>();
        this.findMatchesBreadthFirst(new GenericMatcherTreeNodeAdapter<T>(genericMatcher), this, vector);
        return vector;
    }

    private void findMatchesBreadthFirst(GenericMatcher<GenericTreeNode<T>> genericMatcher, GenericTreeNode<T> genericTreeNode, Vector<GenericTreeNode<T>> vector) {
    }
}

