/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.types;

import java.util.Collection;

class Node {
    private Node parent;
    private Collection<Node> children;

    Node() {
    }

    public Node getParent() {
        return this.parent;
    }

    public Collection<Node> getChildren() {
        return this.children;
    }

    public void setParent(Node node) {
        this.detachFromParent();
        this.attachToParent(node);
    }

    public void unsetParent() {
        this.detachFromParent();
    }

    public void addChild(Node node) {
        node.detachFromParent();
        node.attachToParent(this);
    }

    public void removeChild(Node node) {
        this.children.remove(this);
    }

    private void attachToParent(Node node) {
        this.parent = node;
        this.parent.children.add(this);
    }

    private void detachFromParent() {
        if (this.parent != null) {
            this.parent.children.remove(this);
            this.parent = null;
        }
    }
}

