/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.unit;

import com.ibm.arcs.basic.unit.ByteUnit;
import com.ibm.arcs.basic.unit.Unit;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class BigDecimalWithUnits
implements Comparable<BigDecimalWithUnits> {
    private BigDecimal value;
    private Unit units;

    public BigDecimalWithUnits(BigDecimal bigDecimal, Unit unit) {
        this.value = bigDecimal;
        this.units = unit;
    }

    public BigDecimalWithUnits(long l, Unit unit) {
        this(BigDecimal.valueOf(l), unit);
    }

    public BigDecimalWithUnits(String string) {
    }

    public BigDecimal getValueAs(Unit unit) {
        if (this.units.getMultiplier().compareTo(unit.getMultiplier()) == 0) {
            return this.value;
        }
        if (this.units.getMultiplier().compareTo(unit.getMultiplier()) > 0) {
            BigDecimal bigDecimal = this.units.getMultiplier().divide(unit.getMultiplier(), RoundingMode.HALF_DOWN);
            return this.value.multiply(bigDecimal);
        }
        if (this.value.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = this.units.getMultiplier().divide(unit.getMultiplier(), RoundingMode.HALF_DOWN);
        return this.value.multiply(bigDecimal);
    }

    public String toString() {
        return String.valueOf(this.value.toString()) + ' ' + this.units.toString();
    }

    public String toString(ByteUnit byteUnit) {
        return this.getValueAs(byteUnit).toPlainString();
    }

    @Override
    public int compareTo(BigDecimalWithUnits bigDecimalWithUnits) {
        if (this == bigDecimalWithUnits) {
            return 0;
        }
        return this.getValueAs(ByteUnit.BYTE).compareTo(bigDecimalWithUnits.getValueAs(ByteUnit.BYTE));
    }
}

