/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.unit;

import com.ibm.arcs.basic.unit.Unit;
import java.math.BigDecimal;

public enum BinaryPrefix implements Unit
{
    NONE(BigDecimal.valueOf(1L), ""),
    KIBI(BigDecimal.valueOf(1024L), "Ki"),
    MEBI(BigDecimal.valueOf(1024L).pow(2), "Mi"),
    GIBI(BigDecimal.valueOf(1024L).pow(3), "Gi"),
    TEBI(BigDecimal.valueOf(1024L).pow(4), "Ti"),
    PEBI(BigDecimal.valueOf(1024L).pow(5), "Pi"),
    EXBI(BigDecimal.valueOf(1024L).pow(6), "Ei"),
    ZEBI(BigDecimal.valueOf(1024L).pow(7), "Zi"),
    YOBI(BigDecimal.valueOf(1024L).pow(8), "Yi");

    private final BigDecimal multiplier;
    private final String abbreviation;

    private BinaryPrefix(BigDecimal bigDecimal, String string2) {
        this.multiplier = bigDecimal;
        this.abbreviation = string2;
    }

    @Override
    public BigDecimal getMultiplier() {
        return this.multiplier;
    }

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    public static final BinaryPrefix valueOfAbbreviation(String string) {
        BinaryPrefix[] binaryPrefixArray = BinaryPrefix.values();
        int n = binaryPrefixArray.length;
        int n2 = 0;
        while (n2 < n) {
            BinaryPrefix binaryPrefix = binaryPrefixArray[n2];
            if (binaryPrefix.abbreviation.equals(string)) {
                return binaryPrefix;
            }
            ++n2;
        }
        throw new IllegalArgumentException("no appropriate ByteUnit found");
    }
}

