/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.unit;

import com.ibm.arcs.basic.unit.BinaryPrefix;
import com.ibm.arcs.basic.unit.MetricPrefix;
import com.ibm.arcs.basic.unit.Unit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public enum ByteUnit implements Unit
{
    BYTE(MetricPrefix.NONE),
    KILOBYTE(MetricPrefix.KILO),
    MEGABYTE(MetricPrefix.MEGA),
    GIGABYTE(MetricPrefix.GIGA),
    TERABYTE(MetricPrefix.TERA),
    PETABYTE(MetricPrefix.PETA),
    EXABYTE(MetricPrefix.EXA),
    ZETTABYTE(MetricPrefix.ZETTA),
    YOTTABYTE(MetricPrefix.YOTTA),
    KIBIBYTE(BinaryPrefix.KIBI),
    MEBIBYTE(BinaryPrefix.MEBI),
    GIBIBYTE(BinaryPrefix.GIBI),
    TEBIBYTE(BinaryPrefix.TEBI),
    PEBIBYTE(BinaryPrefix.PEBI),
    EXBIBYTE(BinaryPrefix.EXBI),
    ZEBIBYTE(BinaryPrefix.ZEBI),
    YOBIBYTE(BinaryPrefix.YOBI);

    private final Unit multiplier;
    private final String abbreviation;
    private static final List<ByteUnit> sortedByteUnits;

    static {
        ArrayList<ByteUnit> arrayList = new ArrayList<ByteUnit>(Arrays.asList(ByteUnit.values()));
        Collections.sort(arrayList, new ByteUnitComparator());
        sortedByteUnits = Collections.unmodifiableList(arrayList);
    }

    private ByteUnit(Unit unit) {
        this.multiplier = unit;
        this.abbreviation = String.valueOf(unit.getAbbreviation()) + 'B';
    }

    @Override
    public BigDecimal getMultiplier() {
        return this.multiplier.getMultiplier();
    }

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    public static final ByteUnit valueOfAbbreviation(String string) {
        ByteUnit[] byteUnitArray = ByteUnit.values();
        int n = byteUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            ByteUnit byteUnit = byteUnitArray[n2];
            if (byteUnit.abbreviation.equals(string)) {
                return byteUnit;
            }
            ++n2;
        }
        throw new IllegalArgumentException("no appropriate ByteUnit found");
    }

    public static List<ByteUnit> getSortedByteUnits() {
        return sortedByteUnits;
    }

    private static final class ByteUnitComparator
    implements Comparator<ByteUnit> {
        private ByteUnitComparator() {
        }

        @Override
        public int compare(ByteUnit byteUnit, ByteUnit byteUnit2) {
            return byteUnit.getMultiplier().compareTo(byteUnit2.getMultiplier());
        }
    }
}

