/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.unit;

import com.ibm.arcs.basic.strings.StringUtils;
import com.ibm.arcs.basic.unit.ByteUnit;
import java.math.BigDecimal;
import java.math.MathContext;

public class ByteValue
implements Comparable<ByteValue> {
    private final BigDecimal value;
    private final ByteUnit unit;

    public ByteValue(BigDecimal bigDecimal, ByteUnit byteUnit) {
        this.value = bigDecimal;
        this.unit = byteUnit;
    }

    public ByteValue(long l, ByteUnit byteUnit) {
        this(BigDecimal.valueOf(l), byteUnit);
    }

    public ByteValue(String string) {
        string = StringUtils.removeLeadingTrailingSpaces(string);
        int n = string.indexOf(32);
        this.value = new BigDecimal(string.substring(0, n));
        String string2 = StringUtils.removeLeadingSpaces(string.substring(n + 1));
        this.unit = ByteUnit.valueOfAbbreviation(string2);
    }

    public ByteValue convertTo(ByteUnit byteUnit) {
        if (this.unit.getMultiplier().compareTo(byteUnit.getMultiplier()) == 0) {
            return this;
        }
        return new ByteValue(this.getValueAs(byteUnit), byteUnit);
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public ByteUnit getUnit() {
        return this.unit;
    }

    public BigDecimal getValueAs(ByteUnit byteUnit) {
        return this.getValueAs(byteUnit, MathContext.DECIMAL32);
    }

    public BigDecimal getValueAs(ByteUnit byteUnit, MathContext mathContext) {
        if (this.isValueZero()) {
            return BigDecimal.ZERO;
        }
        if (this.compareMultiplierTo(byteUnit) == 0) {
            return this.value;
        }
        if (this.compareMultiplierTo(byteUnit) > 0) {
            return this.value.multiply(this.unit.getMultiplier()).divide(byteUnit.getMultiplier(), mathContext);
        }
        return this.value.multiply(this.unit.getMultiplier()).divide(byteUnit.getMultiplier(), mathContext);
    }

    private final boolean isValueZero() {
        return this.value.compareTo(BigDecimal.ZERO) == 0;
    }

    private final int compareMultiplierTo(ByteUnit byteUnit) {
        return this.unit.getMultiplier().compareTo(byteUnit.getMultiplier());
    }

    public String toString() {
        return String.valueOf(this.value.toString()) + ' ' + this.unit.getAbbreviation();
    }

    public String toString(ByteUnit byteUnit) {
        return this.convertTo(byteUnit).toString();
    }

    @Override
    public int compareTo(ByteValue byteValue) {
        if (this == byteValue) {
            return 0;
        }
        return this.getValueAs(ByteUnit.BYTE).compareTo(byteValue.getValueAs(ByteUnit.BYTE));
    }

    public ByteValue add(ByteValue byteValue) {
        return new ByteValue(this.value.add(byteValue.convertTo(this.unit).getValue()), this.unit);
    }

    public ByteValue subtract(ByteValue byteValue) {
        return new ByteValue(this.value.subtract(byteValue.convertTo(this.unit).getValue()), this.unit);
    }
}

