/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.unit;

import com.ibm.arcs.basic.unit.Unit;
import java.math.BigDecimal;

public enum MetricPrefix implements Unit
{
    YOCTO(-24, "y"),
    ZEPTO(-21, "z"),
    ATTO(-18, "a"),
    FEMTO(-15, "f"),
    PICO(-12, "p"),
    NANO(-9, "n"),
    MICRO(-6, "u"),
    MILLI(-3, "m"),
    CENTI(-2, "c"),
    DECI(-1, "d"),
    NONE(0, ""),
    DEKA(1, "da"),
    HECTO(2, "h"),
    KILO(3, "k"),
    MEGA(6, "M"),
    GIGA(9, "G"),
    TERA(12, "T"),
    PETA(15, "P"),
    EXA(18, "E"),
    ZETTA(21, "Z"),
    YOTTA(24, "Y");

    private final BigDecimal multiplier;
    private final String abbreviation;

    private MetricPrefix(int n2, String string2) {
        this.multiplier = BigDecimal.ONE.scaleByPowerOfTen(n2);
        this.abbreviation = string2;
    }

    @Override
    public BigDecimal getMultiplier() {
        return this.multiplier;
    }

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    public static final MetricPrefix valueOfAbbreviation(String string) {
        MetricPrefix[] metricPrefixArray = MetricPrefix.values();
        int n = metricPrefixArray.length;
        int n2 = 0;
        while (n2 < n) {
            MetricPrefix metricPrefix = metricPrefixArray[n2];
            if (metricPrefix.abbreviation.equals(string)) {
                return metricPrefix;
            }
            ++n2;
        }
        throw new IllegalArgumentException("no appropriate ByteUnit found");
    }
}

