/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.database.ui.connection.jdbcparameters;

import com.ibm.arcs.basic.parameter.ImmutableParameter;
import com.ibm.arcs.basic.parameter.MutableParameter;
import com.ibm.arcs.basic.parameter.Parameter;
import com.ibm.arcs.basic.parameter.Parameters;
import com.ibm.arcs.database.ui.connection.jdbcparameters.JdbcParameterEditingSupport;
import com.ibm.arcs.database.ui.connection.jdbcparameters.JdbcParametersContentProvider;
import com.ibm.arcs.database.ui.connection.jdbcparameters.JdbcParametersFilter;
import com.ibm.arcs.database.ui.connection.jdbcparameters.JdbcParametersLabelProvider;
import com.ibm.arcs.database.ui.connection.jdbcparameters.JdbcParametersSorter;
import com.ibm.arcs.database.ui.connection.jdbcparameters.dialogs.AddJdbcParameterDialog;
import com.ibm.arcs.status.IStatusProvider;
import com.ibm.arcs.status.ui.AbstractStatusPublishingComposite;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class JdbcParametersComposite
extends AbstractStatusPublishingComposite
implements IStatusProvider {
    private TableViewer viewer;
    private Table table;
    private JdbcParametersSorter sorter;
    private JdbcParametersFilter filter;
    private List<MutableParameter> parameters = new ArrayList<MutableParameter>();

    public JdbcParametersComposite(Composite composite, int n) {
        super(composite, n);
        this.createViewer(composite);
        this.viewer.setInput(this.parameters);
        this.sorter = new JdbcParametersSorter();
        this.viewer.setSorter((ViewerSorter)this.sorter);
        this.filter = new JdbcParametersFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
    }

    protected void checkSubclass() {
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    private void createViewer(Composite composite) {
        this.setLayout((Layout)new FormLayout());
        this.viewer = new TableViewer((Composite)this, 68354);
        this.table = this.viewer.getTable();
        this.createColumns(composite, this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)new JdbcParametersLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new JdbcParametersContentProvider());
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        Label label = new Label((Composite)this, 0);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        label.setLayoutData((Object)formData);
        label.setText("JDBC Parameters:");
        Label label2 = new Label((Composite)this, 0);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment((Control)label, 6, 1024);
        formData2.left = new FormAttachment((Control)label, 0, 16384);
        label2.setLayoutData((Object)formData2);
        label2.setText("Search:");
        final Text text = new Text((Composite)this, 2176);
        FormData formData3 = new FormData();
        formData3.right = new FormAttachment(100);
        formData3.top = new FormAttachment((Control)label2, 0, 128);
        formData3.left = new FormAttachment((Control)label2, 6);
        text.setLayoutData((Object)formData3);
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                JdbcParametersComposite.this.filter.setSearchText(text.getText());
                JdbcParametersComposite.this.viewer.refresh();
            }
        });
        FormData formData4 = new FormData();
        formData4.top = new FormAttachment((Control)text, 6);
        formData4.bottom = new FormAttachment(100);
        formData4.left = new FormAttachment(0);
        formData4.right = new FormAttachment(100);
        this.table.setLayoutData((Object)formData4);
    }

    private void createColumns(Composite composite, final TableViewer tableViewer) {
        String[] stringArray = new String[]{"Key", "Value"};
        int[] nArray = new int[]{100, 100};
        int n = 0;
        while (n < stringArray.length) {
            final int n2 = n;
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            final TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumn.setText(stringArray[n]);
            tableColumn.setWidth(nArray[n]);
            tableColumn.setResizable(true);
            tableColumn.setMoveable(true);
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    JdbcParametersComposite.this.sorter.setColumn(n2);
                    int n = tableViewer.getTable().getSortDirection();
                    n = tableViewer.getTable().getSortColumn() == tableColumn ? (n == 128 ? 1024 : 128) : 1024;
                    JdbcParametersComposite.this.table.setSortDirection(n);
                    JdbcParametersComposite.this.table.setSortColumn(tableColumn);
                    tableViewer.refresh();
                }
            });
            tableViewerColumn.setEditingSupport((EditingSupport)new JdbcParameterEditingSupport((ColumnViewer)tableViewer, n));
            ++n;
        }
        this.table.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                JdbcParametersComposite.this.table.setMenu(JdbcParametersComposite.this.createPopupMenu(JdbcParametersComposite.this.table.getParent()));
            }
        });
    }

    private void createMenuItem(Menu menu, final TableColumn tableColumn) {
        final MenuItem menuItem = new MenuItem(menu, 32);
        menuItem.setText(tableColumn.getText());
        menuItem.setSelection(tableColumn.getResizable());
        menuItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (menuItem.getSelection()) {
                    tableColumn.setWidth(150);
                    tableColumn.setResizable(true);
                } else {
                    tableColumn.setWidth(0);
                    tableColumn.setResizable(false);
                }
            }
        });
    }

    private Menu createPopupMenu(Composite composite) {
        Menu menu = new Menu((Decorations)composite.getShell(), 8);
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText("Add");
        menuItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                JdbcParametersComposite.this.addJdbcParameter();
            }
        });
        MenuItem menuItem2 = new MenuItem(menu, 8);
        menuItem2.setText("Delete");
        menuItem2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                JdbcParametersComposite.this.deleteJdbcParameter();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                JdbcParametersComposite.this.deleteJdbcParameter();
            }
        });
        return menu;
    }

    private void addJdbcParameter() {
        AddJdbcParameterDialog addJdbcParameterDialog = new AddJdbcParameterDialog(this.getShell());
        addJdbcParameterDialog.open();
        if (addJdbcParameterDialog.getJdbcParameter() != null) {
            this.parameters.add(addJdbcParameterDialog.getJdbcParameter());
            this.viewer.refresh();
        }
        addJdbcParameterDialog.close();
    }

    private void deleteJdbcParameter() {
        ISelection iSelection = this.viewer.getSelection();
        if (iSelection != null && iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            for (MutableParameter mutableParameter : iStructuredSelection) {
                this.parameters.remove(mutableParameter);
            }
            this.viewer.refresh();
        }
    }

    public boolean setFocus() {
        return this.viewer.getControl().setFocus();
    }

    public List<ImmutableParameter> getParameters() {
        return Parameters.immutableList(this.parameters);
    }

    public List<String> getParametersAsStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Parameter parameter : this.parameters) {
            String string = String.valueOf(parameter.getKey()) + "=" + parameter.getValue();
            arrayList.add(string);
        }
        return arrayList;
    }

    public IStatus getStatus() {
        return Status.OK_STATUS;
    }
}

