/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.database.ui.connection.jdbcparameters.dialogs;

import com.ibm.arcs.basic.parameter.MutableParameter;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddJdbcParameterDialog
extends TitleAreaDialog {
    private Text keyText;
    private Text valueText;
    private MutableParameter parameter;

    public MutableParameter getJdbcParameter() {
        return this.parameter;
    }

    public AddJdbcParameterDialog(Shell shell) {
        super(shell);
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.setTitle("Add a new JDBC Parameter");
        this.setMessage("Please enter the JDBC parameter information", 1);
        this.getShell().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                AddJdbcParameterDialog.this.processKeyAction(keyEvent.character);
            }
        });
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText("Key");
        this.keyText = new Text(composite, 2048);
        this.keyText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                AddJdbcParameterDialog.this.processKeyAction(keyEvent.character);
            }
        });
        Label label2 = new Label(composite, 0);
        label2.setText("Value");
        this.valueText = new Text(composite, 2048);
        this.valueText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                AddJdbcParameterDialog.this.processKeyAction(keyEvent.character);
            }
        });
        GridData gridData = new GridData(128);
        gridData.horizontalSpan = 2;
        return composite;
    }

    private boolean isCarriageReturnOrLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    private boolean isEscapeKey(char c) {
        return c == '\u001b';
    }

    protected void createButtonsForButtonBar(Composite composite) {
        ++((GridLayout)composite.getLayout()).numColumns;
        Button button = new Button(composite, 8);
        button.setText("OK");
        button.setFont(JFaceResources.getDialogFont());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddJdbcParameterDialog.this.completeAction();
            }
        });
    }

    private void processKeyAction(char c) {
        if (this.isCarriageReturnOrLineBreak(c)) {
            this.completeAction();
        } else if (this.isEscapeKey(c)) {
            this.cancelAction();
        }
    }

    private void completeAction() {
        if (this.isValidInput()) {
            this.parameter = new MutableParameter(this.keyText.getText(), this.valueText.getText());
            this.okPressed();
        } else {
            this.setErrorMessage("Please enter all data");
        }
    }

    private void cancelAction() {
        this.cancelPressed();
    }

    private boolean isValidInput() {
        return this.keyText.getText().length() != 0 && this.valueText.getText().length() != 0;
    }
}

