/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.database;

import com.ibm.arcs.database.DatabaseIdentifier;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractDatabaseIdentifier
implements DatabaseIdentifier {
    private final String value;
    private IStatus validationStatus;

    public AbstractDatabaseIdentifier(String string) {
        this.value = string;
        this.validationStatus = this.validate(string);
    }

    protected abstract IStatus validate(String var1);

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public IStatus getValidationStatus() {
        return this.validationStatus;
    }

    protected static IStatus validateLength(String string, int n) {
        if (string.length() > n) {
            return new Status(4, "com.ibm.arcs.database", "identifier length must be less than " + n);
        }
        if (string.length() == 0) {
            return new Status(4, "com.ibm.arcs.database", "identifier length must be non-zero");
        }
        return Status.OK_STATUS;
    }

    protected static char getFirstChar(String string) {
        if (string.length() > 0) {
            return string.charAt(0);
        }
        throw new IllegalArgumentException("identifier must have non-zero length to retrieve first character");
    }

    protected static char getLastChar(String string) {
        if (string.length() > 0) {
            return string.charAt(string.length() - 1);
        }
        throw new IllegalArgumentException("identifier must have non-zero length to retrieve last character");
    }
}

