/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.database;

import com.ibm.arcs.database.DatabaseProtocol;
import com.ibm.arcs.database.DatabaseService;
import com.ibm.arcs.database.DatabaseServiceRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;

public class DatabaseProtocolRegistry {
    public static final String protocolElementName = "protocol";

    public static final List<DatabaseProtocol> getDatabaseProtocols() throws CoreException {
        ArrayList<DatabaseProtocol> arrayList = new ArrayList<DatabaseProtocol>();
        List<IConfigurationElement> list = DatabaseProtocolRegistry.getDatabaseProtocolConfigurationElements();
        for (IConfigurationElement iConfigurationElement : list) {
            DatabaseProtocol databaseProtocol = null;
            databaseProtocol = DatabaseProtocolRegistry.extractDatabaseProtocol(iConfigurationElement);
            if (databaseProtocol == null) continue;
            arrayList.add(databaseProtocol);
        }
        return arrayList;
    }

    public static final List<DatabaseProtocol> getProtocolsForService(DatabaseService databaseService) throws CoreException {
        List<IConfigurationElement> list = DatabaseProtocolRegistry.getProtcolConfigurationElementsForService(databaseService);
        List<DatabaseProtocol> list2 = DatabaseProtocolRegistry.convertToDatabaseProtocol(list);
        return list2;
    }

    public static final List<DatabaseProtocol> getProtocolsForServiceById(String string) {
        List<IConfigurationElement> list = DatabaseProtocolRegistry.getProtocolConfigurationElementsForServiceById(string);
        List<DatabaseProtocol> list2 = DatabaseProtocolRegistry.convertToDatabaseProtocol(list);
        return list2;
    }

    private static List<DatabaseProtocol> convertToDatabaseProtocol(List<IConfigurationElement> list) {
        ArrayList<DatabaseProtocol> arrayList = new ArrayList<DatabaseProtocol>();
        for (IConfigurationElement iConfigurationElement : list) {
            try {
                DatabaseProtocol databaseProtocol = DatabaseProtocolRegistry.extractDatabaseProtocol(iConfigurationElement);
                arrayList.add(databaseProtocol);
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    public static final List<IConfigurationElement> getProtcolConfigurationElementsForService(DatabaseService databaseService) throws CoreException {
        String string = DatabaseServiceRegistry.getId(databaseService.getClass());
        return DatabaseProtocolRegistry.getProtocolConfigurationElementsForServiceById(string);
    }

    private static final List<IConfigurationElement> getProtocolConfigurationElementsForServiceById(String string) {
        ArrayList<IConfigurationElement> arrayList = new ArrayList<IConfigurationElement>();
        List<IConfigurationElement> list = DatabaseProtocolRegistry.getDatabaseProtocolConfigurationElements();
        for (IConfigurationElement iConfigurationElement : list) {
            arrayList.add(iConfigurationElement);
        }
        return arrayList;
    }

    public static final List<String> extractAppliesTo(IConfigurationElement iConfigurationElement) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
        ArrayList<String> arrayList = new ArrayList<String>(iConfigurationElementArray.length);
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray;
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray2[n2];
            String string = iConfigurationElement2.getAttribute("class");
            arrayList.add(string);
            ++n2;
        }
        return arrayList;
    }

    public static final List<IConfigurationElement> getDatabaseProtocolConfigurationElements() {
        return DatabaseProtocolRegistry.extractDatabaseProtocolConfigurationElements(DatabaseProtocolRegistry.getConfigurationElements());
    }

    public static final List<IConfigurationElement> extractDatabaseProtocolConfigurationElements(List<IConfigurationElement> list) {
        ArrayList<IConfigurationElement> arrayList = new ArrayList<IConfigurationElement>();
        for (IConfigurationElement iConfigurationElement : list) {
            if (!DatabaseProtocolRegistry.isDatabaseProtocolConfigurationElement(iConfigurationElement)) continue;
            arrayList.add(iConfigurationElement);
        }
        return arrayList;
    }

    public static final boolean isDatabaseProtocolConfigurationElement(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getName();
        return string.equals(protocolElementName);
    }

    public static final List<IConfigurationElement> getConfigurationElements() {
        IExtensionRegistry iExtensionRegistry = RegistryFactory.getRegistry();
        if (iExtensionRegistry == null) {
            throw new RuntimeException("Unable to locate Eclipse platform extension registry");
        }
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("com.ibm.arcs.database.protocol");
        return Arrays.asList(iConfigurationElementArray);
    }

    public static final DatabaseProtocol getDatabaseProtocolById(String string) throws CoreException {
        return DatabaseProtocolRegistry.extractDatabaseProtocol(DatabaseProtocolRegistry.getDatabaseProtocolConfigurationElementById(string));
    }

    private static final IConfigurationElement getDatabaseProtocolConfigurationElementById(String string) {
        List<IConfigurationElement> list = DatabaseProtocolRegistry.getDatabaseProtocolConfigurationElements();
        for (IConfigurationElement iConfigurationElement : list) {
            if (!iConfigurationElement.getAttribute("id").equals(string)) continue;
            return iConfigurationElement;
        }
        throw new IllegalArgumentException("unable to locate database protocol with id " + string);
    }

    public static final DatabaseProtocol extractDatabaseProtocol(IConfigurationElement iConfigurationElement) throws CoreException {
        Object object = iConfigurationElement.createExecutableExtension("class");
        if (object instanceof DatabaseProtocol) {
            DatabaseProtocol databaseProtocol = (DatabaseProtocol)object;
            return databaseProtocol;
        }
        throw new IllegalArgumentException("class specified by protocol element is not a database protocol");
    }

    public static final String extractDatabaseProtocolClassName(IConfigurationElement iConfigurationElement) {
        return iConfigurationElement.getAttribute("class");
    }
}

