/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.database;

import com.ibm.arcs.database.DatabaseProtocol;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseProtocols {
    private static final Map<String, DatabaseProtocol> databaseProtocols = new ConcurrentHashMap<String, DatabaseProtocol>();
    private static final Logger logger;

    static {
        DatabaseProtocols.initializeDatabaseProtocols();
        logger = LoggerFactory.getLogger(DatabaseProtocols.class);
    }

    public static DatabaseProtocol getDatabaseProtocol(String string) {
        return databaseProtocols.get(string);
    }

    public static final Collection<DatabaseProtocol> getDatabaseProtocols() {
        return databaseProtocols.values();
    }

    private static void initializeDatabaseProtocols() {
        IExtensionRegistry iExtensionRegistry = RegistryFactory.getRegistry();
        if (iExtensionRegistry == null) {
            throw new RuntimeException("Unable to locate Eclipse platform extension registry");
        }
        try {
            DatabaseProtocols.initializeDatabaseProtocolsFromRegistry(iExtensionRegistry);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.error("Unable to initialize database protocols list", (Throwable)exception);
        }
    }

    private static void initializeDatabaseProtocolsFromRegistry(IExtensionRegistry iExtensionRegistry) throws CoreException {
        IConfigurationElement[] iConfigurationElementArray;
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("com.ibm.arcs.database.protocol");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            Object object = iConfigurationElement.createExecutableExtension("class");
            if (object instanceof DatabaseProtocol) {
                DatabaseProtocol databaseProtocol = (DatabaseProtocol)object;
                String string = iConfigurationElement.getAttribute("name");
                if (databaseProtocols.containsKey(string)) {
                    logger.error("DatabaseProtocol " + string + "(id = " + iConfigurationElement.getAttribute("id") + ") already exists in map ");
                } else {
                    databaseProtocols.put(string, databaseProtocol);
                }
            }
            ++n2;
        }
    }
}

