/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.database;

import com.ibm.arcs.database.DatabaseService;
import com.ibm.arcs.registry.StandardElementAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class DatabaseServiceRegistry {
    public static final String serviceElementName = "service";

    public static final List<DatabaseService> getDatabaseServices() throws CoreException {
        ArrayList<DatabaseService> arrayList = new ArrayList<DatabaseService>();
        List<IConfigurationElement> list = DatabaseServiceRegistry.getConfigurationElements();
        for (IConfigurationElement iConfigurationElement : list) {
            DatabaseService databaseService = null;
            databaseService = DatabaseServiceRegistry.extractDatabaseService(iConfigurationElement);
            if (databaseService == null) continue;
            arrayList.add(databaseService);
        }
        return arrayList;
    }

    public static final List<Class<? extends DatabaseService>> getDatabaseServiceClasses() throws CoreException {
        ArrayList<Class<? extends DatabaseService>> arrayList = new ArrayList<Class<? extends DatabaseService>>();
        List<IConfigurationElement> list = DatabaseServiceRegistry.getConfigurationElements();
        for (IConfigurationElement iConfigurationElement : list) {
            Class<? extends DatabaseService> clazz = DatabaseServiceRegistry.extractDatabaseServiceClass(iConfigurationElement);
            if (clazz == null) continue;
            arrayList.add(clazz);
        }
        return arrayList;
    }

    public static final String getId(Class<? extends DatabaseService> clazz) throws CoreException {
        for (IConfigurationElement iConfigurationElement : DatabaseServiceRegistry.getDatabaseServiceConfigurationElements()) {
            Class<? extends DatabaseService> clazz2 = DatabaseServiceRegistry.extractDatabaseServiceClass(iConfigurationElement);
            if (!clazz2.equals(clazz)) continue;
            return StandardElementAttributes.extractId((IConfigurationElement)iConfigurationElement);
        }
        throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.database", "unable to find id for service " + clazz.getName()));
    }

    public static final List<IConfigurationElement> getDatabaseServiceConfigurationElements() {
        return DatabaseServiceRegistry.extractDatabaseServiceConfigurationElements(DatabaseServiceRegistry.getConfigurationElements());
    }

    public static final List<IConfigurationElement> extractDatabaseServiceConfigurationElements(List<IConfigurationElement> list) {
        ArrayList<IConfigurationElement> arrayList = new ArrayList<IConfigurationElement>();
        for (IConfigurationElement iConfigurationElement : list) {
            if (!DatabaseServiceRegistry.isDatabaseServiceConfigurationElement(iConfigurationElement)) continue;
            arrayList.add(iConfigurationElement);
        }
        return arrayList;
    }

    public static final boolean isDatabaseServiceConfigurationElement(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getName();
        return string.equals(serviceElementName);
    }

    private static final List<IConfigurationElement> getConfigurationElements() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        if (iExtensionRegistry == null) {
            throw new RuntimeException("Unable to locate Eclipse platform extension registry");
        }
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("com.ibm.arcs.database.service");
        return Arrays.asList(iConfigurationElementArray);
    }

    public static final DatabaseService getDatabaseServiceById(String string) throws CoreException {
        return DatabaseServiceRegistry.extractDatabaseService(DatabaseServiceRegistry.getConfigurationElementById(string));
    }

    private static final IConfigurationElement getConfigurationElementById(String string) {
        List<IConfigurationElement> list = DatabaseServiceRegistry.getConfigurationElements();
        for (IConfigurationElement iConfigurationElement : list) {
            if (!iConfigurationElement.getAttribute("id").equals(string)) continue;
            return iConfigurationElement;
        }
        throw new IllegalArgumentException("unable to locate database service with id " + string);
    }

    public static final DatabaseService extractDatabaseService(IConfigurationElement iConfigurationElement) throws CoreException {
        Object object = iConfigurationElement.createExecutableExtension("class");
        if (object instanceof DatabaseService) {
            DatabaseService databaseService = (DatabaseService)object;
            return databaseService;
        }
        throw new IllegalArgumentException("class specified by service element is not a database service");
    }

    public static final Class<? extends DatabaseService> extractDatabaseServiceClass(IConfigurationElement iConfigurationElement) throws CoreException {
        try {
            String string = DatabaseServiceRegistry.extractDatabaseServiceClassName(iConfigurationElement);
            Class<?> clazz = Class.forName(string);
            if (DatabaseService.class.isAssignableFrom(clazz)) {
                Class<?> clazz2 = clazz;
                return clazz2;
            }
            throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.database", "class " + clazz.getName() + " is not assignable to Class<? extends DatabaseService>"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.database", "exception while extracting database service class", (Throwable)classNotFoundException));
        }
    }

    public static final String extractDatabaseServiceClassName(IConfigurationElement iConfigurationElement) {
        return iConfigurationElement.getAttribute("class");
    }
}

