/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.database;

import com.ibm.arcs.database.DatabaseService;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseServices {
    private static final Map<String, DatabaseService> databaseServices = new ConcurrentHashMap<String, DatabaseService>();
    private static final Logger logger;

    static {
        DatabaseServices.initializeDatabaseServices();
        logger = LoggerFactory.getLogger(DatabaseServices.class);
    }

    public static DatabaseService getDatabaseService(String string) {
        return databaseServices.get(string);
    }

    public static final Collection<DatabaseService> getDatabaseServices() {
        return databaseServices.values();
    }

    private static void initializeDatabaseServices() {
        try {
            IConfigurationElement[] iConfigurationElementArray;
            IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
            if (iExtensionRegistry == null) {
                throw new RuntimeException("Unable to locate Eclipse platform extension registry");
            }
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("com.ibm.arcs.database.service");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
                Object object = iConfigurationElement.createExecutableExtension("class");
                if (object instanceof DatabaseService) {
                    DatabaseService databaseService = (DatabaseService)object;
                    String string = iConfigurationElement.getAttribute("name");
                    if (databaseServices.containsKey(string)) {
                        logger.error("DatabaseService " + string + "(id = " + iConfigurationElement.getAttribute("id") + ") already exists in map ");
                    } else {
                        databaseServices.put(string, databaseService);
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            logger.error("Unable to initialize database services list", (Throwable)exception);
        }
    }
}

