/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.database.connection;

import com.ibm.arcs.database.DatabaseName;
import com.ibm.arcs.database.DatabaseProtocol;
import com.ibm.arcs.database.connection.ConnectionParameters;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionParameters
implements ConnectionParameters {
    protected final Logger logger;
    protected final Properties EMPTY_PROPERTIES = new Properties();
    private final Driver driver;
    private final String userName;
    private final String userPassword;
    private final DatabaseName databaseName;
    private final DatabaseProtocol databaseProtocol;
    private final List<String> extraJdbcParameters;
    private final Map<String, Class<?>> typeMapAdditions;

    public AbstractConnectionParameters(Class<?> clazz, Driver driver, DatabaseProtocol databaseProtocol, DatabaseName databaseName, String string, String string2, List<String> list, Map<String, Class<?>> map) {
        this.driver = driver;
        this.databaseProtocol = databaseProtocol;
        this.databaseName = databaseName;
        this.userName = string;
        this.userPassword = string2;
        this.extraJdbcParameters = list;
        this.typeMapAdditions = AbstractConnectionParameters.copyTypeMap(map);
        this.logger = LoggerFactory.getLogger((String)clazz.getName());
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        Connection connection = this.driver.connect(this.getUrl(), this.EMPTY_PROPERTIES);
        Map<String, Class<?>> map = connection.getTypeMap();
        if (this.hasTypeMapAdditions() && map != null) {
            map.putAll(this.getTypeMapAdditions());
        }
        return connection;
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getUserPassword() {
        return this.userPassword;
    }

    @Override
    public DatabaseName getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public DatabaseProtocol getDatabaseProtocol() {
        return this.databaseProtocol;
    }

    @Override
    public List<String> getJdbcParameters() {
        return this.extraJdbcParameters;
    }

    @Override
    public Map<String, Class<?>> getTypeMapAdditions() {
        return Collections.unmodifiableMap(this.typeMapAdditions);
    }

    protected static final Map<String, Class<?>> copyTypeMap(Map<String, Class<?>> map) {
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        for (String string : map.keySet()) {
            concurrentHashMap.put(string, map.get(string));
        }
        return concurrentHashMap;
    }

    protected final boolean hasUserName() {
        return this.userName != null && this.userName.length() > 0;
    }

    protected final boolean hasUserPassword() {
        return this.userPassword != null && this.userPassword.trim().length() > 0;
    }

    protected final boolean hasDatabaseProtocol() {
        return this.databaseProtocol != null;
    }

    protected final boolean hasDatabaseName() {
        return this.databaseName != null && this.databaseName.getName().trim().length() > 0;
    }

    protected final boolean hasExtraJdbcParameters() {
        return this.extraJdbcParameters.size() > 0;
    }

    protected boolean hasTypeMapAdditions() {
        return this.typeMapAdditions.size() > 0;
    }

    protected void appendExtraJdbcParametersToUrl(StringBuilder stringBuilder) {
        if (this.hasExtraJdbcParameters()) {
            Iterator<String> iterator = this.extraJdbcParameters.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                stringBuilder.append(string);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(';');
            }
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.databaseName == null ? 0 : this.databaseName.hashCode());
        n = 31 * n + (this.databaseProtocol == null ? 0 : this.databaseProtocol.hashCode());
        n = 31 * n + (this.extraJdbcParameters == null ? 0 : this.extraJdbcParameters.hashCode());
        n = 31 * n + (this.typeMapAdditions == null ? 0 : this.typeMapAdditions.hashCode());
        n = 31 * n + (this.userName == null ? 0 : this.userName.hashCode());
        n = 31 * n + (this.userPassword == null ? 0 : this.userPassword.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof AbstractConnectionParameters)) {
            return false;
        }
        AbstractConnectionParameters abstractConnectionParameters = (AbstractConnectionParameters)object;
        if (this.databaseName == null ? abstractConnectionParameters.databaseName != null : !this.databaseName.equals(abstractConnectionParameters.databaseName)) {
            return false;
        }
        if (this.databaseProtocol == null ? abstractConnectionParameters.databaseProtocol != null : !this.databaseProtocol.equals(abstractConnectionParameters.databaseProtocol)) {
            return false;
        }
        if (this.driver == null ? abstractConnectionParameters.driver != null : !this.driver.getClass().equals(abstractConnectionParameters.driver.getClass())) {
            return false;
        }
        if (this.extraJdbcParameters == null ? abstractConnectionParameters.extraJdbcParameters != null : !this.extraJdbcParameters.equals(abstractConnectionParameters.extraJdbcParameters)) {
            return false;
        }
        if (this.typeMapAdditions == null ? abstractConnectionParameters.typeMapAdditions != null : !this.typeMapAdditions.equals(abstractConnectionParameters.typeMapAdditions)) {
            return false;
        }
        if (this.userName == null ? abstractConnectionParameters.userName != null : !this.userName.equals(abstractConnectionParameters.userName)) {
            return false;
        }
        return !(this.userPassword == null ? abstractConnectionParameters.userPassword != null : !this.userPassword.equals(abstractConnectionParameters.userPassword));
    }
}

