/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.database.connection;

import com.ibm.arcs.database.DatabaseName;
import com.ibm.arcs.database.DatabaseProtocol;
import com.ibm.arcs.database.DatabaseServerName;
import com.ibm.arcs.database.connection.ConnectionParametersBuilder;
import com.ibm.arcs.host.Host;
import com.ibm.arcs.host.HostCatalog;
import com.ibm.arcs.host.HostName;
import com.ibm.arcs.host.HostPort;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractConnectionParametersBuilder
implements ConnectionParametersBuilder {
    private HostName hostName;
    private HostPort hostPort;
    private String userName = "";
    private String userPassword = "";
    private DatabaseName databaseName;
    private DatabaseServerName databaseServerName;
    private DatabaseProtocol databaseProtocol;
    private List<String> extraJdbcParameters = new ArrayList<String>();
    private Map<String, Class<?>> typeMap = new HashMap();

    @Override
    public void setHostName(HostName hostName) {
        this.hostName = hostName;
    }

    @Override
    public void setHostName(String string) {
        Host host = HostCatalog.getNewHost();
        this.hostName = host.addHostName(string);
    }

    @Override
    public HostName getHostName() {
        return this.hostName;
    }

    @Override
    public void setHostPort(HostPort hostPort) {
        this.hostPort = hostPort;
    }

    @Override
    public void setHostPort(int n) {
        this.hostPort = new HostPort(n);
    }

    @Override
    public HostPort getHostPort() {
        return this.hostPort;
    }

    @Override
    public void setUserName(String string) {
        this.userName = string;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setUserPassword(String string) {
        this.userPassword = string;
    }

    @Override
    public String getUserPassword() {
        return this.userPassword;
    }

    @Override
    public void setDatabaseName(DatabaseName databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    public DatabaseName getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public void setDatabaseServerName(DatabaseServerName databaseServerName) {
        this.databaseServerName = databaseServerName;
    }

    @Override
    public DatabaseServerName getDatabaseServerName() {
        return this.databaseServerName;
    }

    @Override
    public void setDatabaseProtocol(DatabaseProtocol databaseProtocol) {
        this.databaseProtocol = databaseProtocol;
    }

    @Override
    public DatabaseProtocol getDatabaseProtocol() {
        return this.databaseProtocol;
    }

    @Override
    public boolean addJdbcParameter(String string) {
        return this.extraJdbcParameters.add(string);
    }

    @Override
    public boolean addJdbcParameter(List<String> list) {
        return this.extraJdbcParameters.addAll(list);
    }

    @Override
    public boolean removeJdbcParameter(String string) {
        return this.extraJdbcParameters.remove(string);
    }

    @Override
    public List<String> getAllJdbcParameters() {
        return Collections.unmodifiableList(this.extraJdbcParameters);
    }

    @Override
    public Class<?> addToTypeMap(String string, Class<?> clazz) {
        return this.typeMap.put(string, clazz);
    }

    @Override
    public void addToTypeMap(Map<String, Class<?>> map) {
        this.typeMap.putAll(map);
    }

    @Override
    public Class<?> removeFromTypeMap(String string) {
        return this.typeMap.remove(string);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return Collections.unmodifiableMap(this.typeMap);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.databaseName == null ? 0 : this.databaseName.hashCode());
        n = 31 * n + (this.databaseProtocol == null ? 0 : this.databaseProtocol.hashCode());
        n = 31 * n + (this.databaseServerName == null ? 0 : this.databaseServerName.hashCode());
        n = 31 * n + (this.extraJdbcParameters == null ? 0 : this.extraJdbcParameters.hashCode());
        n = 31 * n + (this.hostName == null ? 0 : this.hostName.hashCode());
        n = 31 * n + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        n = 31 * n + (this.typeMap == null ? 0 : this.typeMap.hashCode());
        n = 31 * n + (this.userName == null ? 0 : this.userName.hashCode());
        n = 31 * n + (this.userPassword == null ? 0 : this.userPassword.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof AbstractConnectionParametersBuilder)) {
            return false;
        }
        AbstractConnectionParametersBuilder abstractConnectionParametersBuilder = (AbstractConnectionParametersBuilder)object;
        if (this.databaseName == null ? abstractConnectionParametersBuilder.databaseName != null : !this.databaseName.equals(abstractConnectionParametersBuilder.databaseName)) {
            return false;
        }
        if (this.databaseProtocol == null ? abstractConnectionParametersBuilder.databaseProtocol != null : !this.databaseProtocol.equals(abstractConnectionParametersBuilder.databaseProtocol)) {
            return false;
        }
        if (this.databaseServerName == null ? abstractConnectionParametersBuilder.databaseServerName != null : !this.databaseServerName.equals(abstractConnectionParametersBuilder.databaseServerName)) {
            return false;
        }
        if (this.extraJdbcParameters == null ? abstractConnectionParametersBuilder.extraJdbcParameters != null : !this.extraJdbcParameters.equals(abstractConnectionParametersBuilder.extraJdbcParameters)) {
            return false;
        }
        if (this.hostName == null ? abstractConnectionParametersBuilder.hostName != null : !this.hostName.equals((Object)abstractConnectionParametersBuilder.hostName)) {
            return false;
        }
        if (this.hostPort == null ? abstractConnectionParametersBuilder.hostPort != null : !this.hostPort.equals((Object)abstractConnectionParametersBuilder.hostPort)) {
            return false;
        }
        if (this.typeMap == null ? abstractConnectionParametersBuilder.typeMap != null : !this.typeMap.equals(abstractConnectionParametersBuilder.typeMap)) {
            return false;
        }
        if (this.userName == null ? abstractConnectionParametersBuilder.userName != null : !this.userName.equals(abstractConnectionParametersBuilder.userName)) {
            return false;
        }
        return !(this.userPassword == null ? abstractConnectionParametersBuilder.userPassword != null : !this.userPassword.equals(abstractConnectionParametersBuilder.userPassword));
    }
}

