/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.database.connection;

import com.ibm.arcs.basic.strings.StringUtils;
import com.ibm.arcs.database.DatabaseProtocol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class JdbcDriversProperty {
    private static final String KEY = "jdbc.drivers";
    private static final ArrayList<String> VALUES = new ArrayList();

    public static void addValue(String string) {
        VALUES.add(string);
    }

    public static void addValue(int n, String string) {
        VALUES.add(n, string);
    }

    public static List<String> getValues() {
        return Collections.unmodifiableList(VALUES);
    }

    public static boolean contains(String string) {
        return VALUES.contains(string);
    }

    public static void removeValue(int n) {
        VALUES.remove(n);
    }

    public static void removeValue(String string) {
        VALUES.remove(string);
    }

    public static void clearValues() {
        VALUES.clear();
    }

    public static void loadFromSystemProperty() {
        String[] stringArray;
        VALUES.clear();
        String string = System.getProperty(KEY);
        if (string != null && (stringArray = StringUtils.splitAtDelimiter((String)string, (char)':')).length > 0) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                JdbcDriversProperty.addValue(string2);
                ++n2;
            }
        }
    }

    public static void setSystemProperty() {
        System.setProperty(KEY, JdbcDriversProperty.convertValuesToPropertyValue());
    }

    public static void setupForProtocols(DatabaseProtocol ... databaseProtocolArray) {
    }

    private static String convertValuesToPropertyValue() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = VALUES.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(':');
        }
        return stringBuilder.toString();
    }
}

