/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.database.connection;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.PooledConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcObjectClosers {
    public static void closeWithoutException(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            Logger logger = LoggerFactory.getLogger((String)resultSet.getClass().getCanonicalName());
            logger.error("Error while closing ResultSet, SQLException", (Throwable)sQLException);
        }
        catch (RuntimeException runtimeException) {
            Logger logger = LoggerFactory.getLogger((String)resultSet.getClass().getCanonicalName());
            logger.error("Error while closing ResultSet, RuntimeException", (Throwable)runtimeException);
        }
        catch (Exception exception) {
            Logger logger = LoggerFactory.getLogger((String)resultSet.getClass().getCanonicalName());
            logger.error("Error while closing ResultSet, Unknown Exception type", (Throwable)exception);
        }
    }

    public static void closeWithoutException(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            Logger logger = LoggerFactory.getLogger((String)statement.getClass().getCanonicalName());
            logger.error("Error while closing Statement, SQLException", (Throwable)sQLException);
        }
        catch (RuntimeException runtimeException) {
            Logger logger = LoggerFactory.getLogger((String)statement.getClass().getCanonicalName());
            logger.error("Error while closing Statement, RuntimeException", (Throwable)runtimeException);
        }
        catch (Exception exception) {
            Logger logger = LoggerFactory.getLogger((String)statement.getClass().getCanonicalName());
            logger.error("Error while closing Statement, Unknown Exception type", (Throwable)exception);
        }
    }

    public static void closeWithoutException(Connection connection) {
        JdbcObjectClosers.closeWithoutException(connection, false);
    }

    public static void closeWithoutException(Connection connection, boolean bl) {
        Logger logger;
        if (bl) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                if (databaseMetaData.supportsTransactions()) {
                    connection.commit();
                }
            }
            catch (SQLException sQLException) {
                logger = LoggerFactory.getLogger((String)connection.getClass().getCanonicalName());
                logger.error("Error while closing connection during transaction commit, SQLException", (Throwable)sQLException);
            }
            catch (RuntimeException runtimeException) {
                logger = LoggerFactory.getLogger((String)connection.getClass().getCanonicalName());
                logger.error("Error while closing connection during transaction commit, RuntimeException", (Throwable)runtimeException);
            }
            catch (Exception exception) {
                logger = LoggerFactory.getLogger((String)connection.getClass().getCanonicalName());
                logger.error("Error while closing connection during transaction commit, Unknown Exception type", (Throwable)exception);
            }
        }
        try {
            connection.close();
        }
        catch (Exception exception) {
            logger = LoggerFactory.getLogger((String)connection.getClass().getCanonicalName());
            logger.error("Error while closing Connection, Unknown Exception type", (Throwable)exception);
        }
    }

    public static void closeWithoutException(PooledConnection pooledConnection) {
        try {
            pooledConnection.close();
        }
        catch (SQLException sQLException) {
            Logger logger = LoggerFactory.getLogger((String)pooledConnection.getClass().getCanonicalName());
            logger.error("Error while closing PooledConnection, SQLException", (Throwable)sQLException);
        }
        catch (RuntimeException runtimeException) {
            Logger logger = LoggerFactory.getLogger((String)pooledConnection.getClass().getCanonicalName());
            logger.error("Error while closing PooledConnection, RuntimeException", (Throwable)runtimeException);
        }
        catch (Exception exception) {
            Logger logger = LoggerFactory.getLogger((String)pooledConnection.getClass().getCanonicalName());
            logger.error("Error while closing PooledConnection, Unknown Exception type", (Throwable)exception);
        }
    }
}

