/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.database.connection.pool;

import com.ibm.arcs.database.connection.ConnectionParameters;
import com.ibm.arcs.database.connection.ConnectionParametersBuilder;
import com.ibm.arcs.database.connection.ConnectionPool;
import com.ibm.arcs.database.connection.JdbcObjectClosers;
import com.ibm.arcs.database.connection.pool.ConnectionPoolStatistics;
import com.ibm.arcs.database.connection.pool.PooledConnectionEventListener;
import com.ibm.arcs.database.connection.pool.SimpleConnectionPoolStatistics;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;

public abstract class AbstractConnectionPool
implements ConnectionPool {
    protected ConnectionParameters connectionParameters;
    protected final ConnectionPoolDataSource connectionPoolDataSource;
    protected final HashSet<PooledConnection> activeConnections = new HashSet();
    protected final HashedMap idleConnections = new HashedMap();
    protected final PooledConnectionEventListener pooledConnectionEventListener;
    protected static final long semaphoreTimeoutDefault = 30L;
    protected static final TimeUnit semaphoreTimeoutTimeUnitDefault = TimeUnit.SECONDS;
    protected long semaphoreTimeout;
    protected TimeUnit semaphoreTimeoutTimeUnit;
    protected Semaphore semaphore;
    protected static final long idleConnectionTimeoutDefault = 120L;
    protected static final TimeUnit idleConnectionTimeoutTimeUnitDefault = TimeUnit.SECONDS;
    protected long idleConnectionTimeout = 120L;
    protected TimeUnit idleConnectionTimeoutTimeUnit = idleConnectionTimeoutTimeUnitDefault;
    protected long idleConnectionTimeoutMillis;
    protected static final int maximumConnectionsDefault = 50;
    protected int maximumConnections;
    protected static final int poolSizeInitialDefault = 0;
    protected int poolSizeInitial = 0;
    protected static final int minimumPoolSizeDefault = 0;
    protected int minimumPoolSize;
    protected static final int maximumPoolSizeDefault = 50;
    protected int maximumPoolSize;
    protected boolean isClosed = false;
    private long totalNewConnectionsCreated = 0L;
    private long totalIdleConnectionsReused = 0L;
    private long lastNewConnectionAllocationTime = 0L;
    protected final Logger logger;

    protected abstract Logger getLogger();

    protected abstract boolean harvestExpiredIdleConnectionsWhileReturning();

    public AbstractConnectionPool(ConnectionParameters connectionParameters) throws Exception {
        this(connectionParameters, 0);
    }

    public AbstractConnectionPool(ConnectionParameters connectionParameters, int n) throws Exception {
        this.connectionParameters = connectionParameters;
        this.connectionPoolDataSource = connectionParameters.getDatabaseProtocol().createConnectionPoolDataSource(connectionParameters);
        this.pooledConnectionEventListener = new PooledConnectionEventListener(this);
        this.logger = this.getLogger();
        this.configureDefaults();
        this.setInitialPoolSize(n);
    }

    @Override
    public synchronized ConnectionParameters getConnectionParameters() {
        return this.connectionParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        AbstractConnectionPool abstractConnectionPool = this;
        synchronized (abstractConnectionPool) {
            if (this.isClosed) {
                throw new IllegalStateException("Connection pool manager is disposed");
            }
        }
        try {
            if (this.semaphore.tryAcquire(this.semaphoreTimeout, this.semaphoreTimeoutTimeUnit)) {
                return this.getConnectionInternal();
            }
            throw new RuntimeException("Unable to acquire lock before semaphore timeout");
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted while trying to acquire a connection", interruptedException);
        }
    }

    protected synchronized Connection getConnectionInternal() throws SQLException {
        PooledConnection pooledConnection = null;
        if (this.idleConnections.isEmpty()) {
            this.logger.debug("Allocating new pooled connection to service request");
            long l = System.currentTimeMillis();
            pooledConnection = this.connectionPoolDataSource.getPooledConnection();
            ++this.totalNewConnectionsCreated;
            this.lastNewConnectionAllocationTime = System.currentTimeMillis() - l;
        } else {
            this.logger.debug("Reusing idle pooled connection to service request");
            MapIterator mapIterator = this.idleConnections.mapIterator();
            mapIterator.next();
            pooledConnection = (PooledConnection)mapIterator.getKey();
            mapIterator.remove();
            ++this.totalIdleConnectionsReused;
        }
        Connection connection = pooledConnection.getConnection();
        this.addTypeMapToConnection(connection);
        this.activeConnections.add(pooledConnection);
        pooledConnection.addConnectionEventListener(this.pooledConnectionEventListener);
        this.logger.debug("activeConnections.size() = " + this.activeConnections.size());
        this.logger.debug("idleConnections.size() = " + this.idleConnections.size());
        return connection;
    }

    private void addTypeMapToConnection(Connection connection) throws SQLException {
        Map<String, Class<?>> map = connection.getTypeMap();
        Map<String, Class<?>> map2 = this.connectionParameters.getTypeMapAdditions();
        for (String string : map2.keySet()) {
            map.put(string, map2.get(string));
        }
    }

    @Override
    public synchronized void returnConnection(PooledConnection pooledConnection) {
        this.logger.debug("returning pooled connection " + pooledConnection.toString() + " to idle pool");
        if (!this.isClosed) {
            if (this.returnActiveConnection(pooledConnection)) {
                return;
            }
            if (this.returnIdleConnection(pooledConnection)) {
                return;
            }
            throw new IllegalArgumentException("Connection " + pooledConnection.toString() + " is not managed by this connection pool manager");
        }
        this.disposeConnection(pooledConnection);
    }

    private synchronized boolean returnActiveConnection(PooledConnection pooledConnection) {
        boolean bl = this.activeConnections.remove(pooledConnection);
        if (bl) {
            this.semaphore.release();
            if (this.idleConnections.size() < this.maximumPoolSize) {
                this.idleConnections.put((Object)pooledConnection, (Object)new Long(System.currentTimeMillis()));
                this.logger.debug("activeConnections.size() = " + this.activeConnections.size());
                this.logger.debug("idleConnections.size() = " + this.idleConnections.size());
            } else {
                this.logger.debug("returned connection was disposed of because maximum idle pool size has been reached");
                JdbcObjectClosers.closeWithoutException(pooledConnection);
            }
            if (this.harvestExpiredIdleConnectionsWhileReturning()) {
                this.harvestExpiredIdleConnections();
            }
        }
        return bl;
    }

    private synchronized boolean returnIdleConnection(PooledConnection pooledConnection) {
        boolean bl = this.idleConnections.containsKey((Object)pooledConnection);
        if (bl) {
            throw new RuntimeException("Attempt to return a pooled connection that is already in the idle connections pool");
        }
        return bl;
    }

    @Override
    public synchronized void disposeConnection(PooledConnection pooledConnection) {
        this.logger.debug("disposing of pooled connection " + pooledConnection.toString());
        if (this.disposeActiveConnection(pooledConnection)) {
            return;
        }
        if (this.disposeIdleConnection(pooledConnection)) {
            return;
        }
        throw new IllegalArgumentException("Connection " + pooledConnection.toString() + " is not managed by this connection pool manager");
    }

    private synchronized boolean disposeActiveConnection(PooledConnection pooledConnection) {
        boolean bl = this.activeConnections.remove(pooledConnection);
        if (bl) {
            this.semaphore.release();
            JdbcObjectClosers.closeWithoutException(pooledConnection);
        }
        return bl;
    }

    private synchronized boolean disposeIdleConnection(PooledConnection pooledConnection) {
        if (this.idleConnections.size() > this.minimumPoolSize) {
            boolean bl;
            boolean bl2 = bl = this.idleConnections.remove((Object)pooledConnection) != null;
            if (bl) {
                this.expandIdlePool(this.minimumPoolSize);
            }
            return bl;
        }
        throw new RuntimeException("Attempt to violate minimum pool size specification");
    }

    @Override
    public synchronized void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.shrinkIdlePool(0);
        }
    }

    @Override
    public synchronized void closeNow() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.shrinkIdlePool(0);
            this.closeActivePool();
        }
    }

    @Override
    public Class<?> addToTypeMap(String string, Class<?> clazz) throws SQLException {
        Class<?> clazz2 = null;
        ConnectionParametersBuilder connectionParametersBuilder = this.connectionParameters.getConnectionParametersBuilder();
        clazz2 = connectionParametersBuilder.addToTypeMap(string, clazz);
        this.connectionParameters = connectionParametersBuilder.getConnectionParameters();
        this.updateConnectionTypeMaps();
        return clazz2;
    }

    @Override
    public synchronized void addToTypeMap(Map<String, Class<?>> map) throws SQLException {
        ConnectionParametersBuilder connectionParametersBuilder = this.connectionParameters.getConnectionParametersBuilder();
        connectionParametersBuilder.addToTypeMap(map);
        this.connectionParameters = connectionParametersBuilder.getConnectionParameters();
        this.updateConnectionTypeMaps();
    }

    @Override
    public synchronized Class<?> removeFromTypeMap(String string) throws SQLException {
        Class<?> clazz = null;
        ConnectionParametersBuilder connectionParametersBuilder = this.connectionParameters.getConnectionParametersBuilder();
        clazz = connectionParametersBuilder.removeFromTypeMap(string);
        this.connectionParameters = connectionParametersBuilder.getConnectionParameters();
        this.updateConnectionTypeMaps();
        return clazz;
    }

    @Override
    public synchronized Map<String, Class<?>> getTypeMap() {
        return this.connectionParameters.getTypeMapAdditions();
    }

    private final void updateConnectionTypeMaps() throws SQLException {
        this.updateActiveConnectionTypeMaps();
        this.updateIdleConnectionTypeMaps();
    }

    private final void updateActiveConnectionTypeMaps() throws SQLException {
        for (PooledConnection pooledConnection : this.activeConnections) {
            this.updatePooledConnectionTypeMap(pooledConnection);
        }
    }

    private final void updateIdleConnectionTypeMaps() throws SQLException {
        MapIterator mapIterator = this.idleConnections.mapIterator();
        while (mapIterator.hasNext()) {
            mapIterator.next();
            this.updatePooledConnectionTypeMap((PooledConnection)mapIterator.getKey());
        }
    }

    private final void updatePooledConnectionTypeMap(PooledConnection pooledConnection) throws SQLException {
        Connection connection = pooledConnection.getConnection();
        Map<String, Class<?>> map = this.connectionParameters.getTypeMapAdditions();
        Map<String, Class<?>> map2 = connection.getTypeMap();
        for (String string : map.keySet()) {
            map2.put(string, map.get(string));
        }
    }

    private void configureDefaults() {
        this.setSemaphoreTimeout(30L, semaphoreTimeoutTimeUnitDefault);
        this.setIdleConnectionTimeout(120L, idleConnectionTimeoutTimeUnitDefault);
        this.setMaximumConnections(50);
        this.setMaximumPoolSize(50);
    }

    @Override
    public synchronized void setSemaphoreTimeout(long l, TimeUnit timeUnit) {
        this.semaphoreTimeout = l;
        this.semaphoreTimeoutTimeUnit = timeUnit;
    }

    @Override
    public synchronized void setIdleConnectionTimeout(long l, TimeUnit timeUnit) {
        this.idleConnectionTimeout = l;
        this.idleConnectionTimeoutTimeUnit = timeUnit;
        this.idleConnectionTimeoutMillis = this.idleConnectionTimeoutTimeUnit.toMillis(this.idleConnectionTimeout);
    }

    @Override
    public synchronized void setMinimumPoolSize(int n) throws Exception {
        if (n < 0) {
            throw new IllegalArgumentException("minimumPoolSize must be equal to or greater than zero");
        }
        if (n >= this.maximumPoolSize) {
            throw new IllegalArgumentException("minimumPoolSize must be less than maximumPoolSize");
        }
        this.expandIdlePool(n);
        this.minimumPoolSize = n;
    }

    @Override
    public synchronized void setMaximumPoolSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maximumPoolSize must be equal to or greater than zero");
        }
        if (this.minimumPoolSize >= n) {
            throw new IllegalArgumentException("minimumPoolSize must be less than maximumPoolSize");
        }
        MapIterator mapIterator = this.idleConnections.mapIterator();
        while (this.idleConnections.size() > n) {
            if (mapIterator.hasNext()) {
                mapIterator.next();
                mapIterator.remove();
                continue;
            }
            throw new IllegalArgumentException("Unable to resize");
        }
        this.maximumPoolSize = n;
    }

    @Override
    public synchronized void setMaximumConnections(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maximumConnections must be greater than zero");
        }
        if (this.activeConnections.size() > n) {
            throw new IllegalArgumentException("More connections are currently active than the requeted maximum number of connections");
        }
        int n2 = this.activeConnections.size() + this.idleConnections.size();
        int n3 = n - this.activeConnections.size();
        if (n2 > n) {
            this.shrinkIdlePool(n3);
        }
        this.semaphore = new Semaphore(n3, true);
        this.maximumConnections = n;
    }

    @Override
    public ConnectionPoolStatistics getConnectionPoolStatistics() {
        return new SimpleConnectionPoolStatistics(this.activeConnections.size(), this.idleConnections.size(), this.totalNewConnectionsCreated, this.totalIdleConnectionsReused, this.lastNewConnectionAllocationTime);
    }

    protected final synchronized void harvestExpiredIdleConnections() {
        this.logger.trace("harvesting expired idle connections started");
        MapIterator mapIterator = this.idleConnections.mapIterator();
        long l = System.currentTimeMillis();
        while (mapIterator.hasNext() && this.idleConnections.size() > this.minimumPoolSize) {
            mapIterator.next();
            long l2 = (Long)mapIterator.getValue();
            long l3 = l - l2;
            if (!this.isGreaterThanIdleConnectionTimeout(l3)) continue;
            PooledConnection pooledConnection = (PooledConnection)mapIterator.getKey();
            this.logger.trace("reaping idle pooled connection, connectionIdleTime = " + l3 + " ms, idleConnectionTimeout = " + this.idleConnectionTimeoutMillis + " ms");
            JdbcObjectClosers.closeWithoutException(pooledConnection);
            mapIterator.remove();
        }
        this.logger.trace("harvesting expired idle connections completed");
    }

    protected final boolean isGreaterThanIdleConnectionTimeout(long l) {
        return l > this.idleConnectionTimeoutMillis;
    }

    private final synchronized void setInitialPoolSize(int n) throws SQLException {
        if (this.maximumConnections > n) {
            this.poolSizeInitial = n;
            this.expandIdlePool(n);
            assert (this.activeConnections.size() == 0);
        } else {
            throw new IllegalArgumentException("Initial pool size cannot be greater than maximum connections");
        }
    }

    private final synchronized void setIdlePoolSize(int n) throws SQLException {
        if (n < this.idleConnections.size()) {
            this.shrinkIdlePool(n);
        } else if (n > this.idleConnections.size()) {
            this.expandIdlePool(n);
        }
    }

    private final synchronized void shrinkIdlePool(int n) {
        MapIterator mapIterator = this.idleConnections.mapIterator();
        while (this.idleConnections.size() > n) {
            mapIterator.next();
            PooledConnection pooledConnection = (PooledConnection)mapIterator.getKey();
            JdbcObjectClosers.closeWithoutException(pooledConnection);
            mapIterator.remove();
        }
        assert (this.idleConnections.size() == n);
    }

    private final synchronized void expandIdlePool(int n) {
        int n2 = n - this.idleConnections.size();
        Connection[] connectionArray = new Connection[n2];
        int n3 = 0;
        while (n3 < n2) {
            try {
                connectionArray[n3] = this.getConnection();
            }
            catch (SQLException sQLException) {}
            ++n3;
        }
        Connection[] connectionArray2 = connectionArray;
        int n4 = connectionArray.length;
        int n5 = 0;
        while (n5 < n4) {
            Connection connection = connectionArray2[n5];
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
            ++n5;
        }
        connectionArray = null;
        assert (this.idleConnections.size() == n);
    }

    private final synchronized void closeActivePool() {
        Iterator<PooledConnection> iterator = this.activeConnections.iterator();
        while (iterator.hasNext()) {
            PooledConnection pooledConnection = iterator.next();
            JdbcObjectClosers.closeWithoutException(pooledConnection);
            iterator.remove();
        }
        assert (this.activeConnections.size() == 0);
    }
}

