/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.database.connection.pool;

import com.ibm.arcs.database.connection.ConnectionParameters;
import com.ibm.arcs.database.connection.pool.AbstractConnectionPool;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedConnectionPool
extends AbstractConnectionPool {
    private static final long SERVICE_INTERVAL_DEFAULT = 10L;
    private static final TimeUnit SERVICE_INTERVAL_TIME_UNIT_DEFAULT = TimeUnit.SECONDS;
    private long serviceInterval;
    private TimeUnit serviceIntervalTimeUnit = SERVICE_INTERVAL_TIME_UNIT_DEFAULT;

    public AdvancedConnectionPool(ConnectionParameters connectionParameters) throws Exception {
        this(connectionParameters, 0);
    }

    public AdvancedConnectionPool(ConnectionParameters connectionParameters, int n) throws Exception {
        super(connectionParameters, n);
        this.configureDefaults();
        this.configureThreadPool();
    }

    @Override
    protected boolean harvestExpiredIdleConnectionsWhileReturning() {
        return false;
    }

    @Override
    protected Logger getLogger() {
        if (this.logger == null) {
            return LoggerFactory.getLogger(AdvancedConnectionPool.class);
        }
        return this.logger;
    }

    private void configureDefaults() {
        this.setServiceInterval(10L, SERVICE_INTERVAL_TIME_UNIT_DEFAULT);
    }

    public synchronized void setServiceInterval(long l, TimeUnit timeUnit) {
        this.serviceInterval = l;
        this.serviceIntervalTimeUnit = timeUnit;
    }

    private synchronized void configureThreadPool() {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, new IdleConnectionHarvesterThreadFactory());
        scheduledExecutorService.scheduleAtFixedRate(new IdleConnectionHarvester(), 0L, this.serviceInterval, this.serviceIntervalTimeUnit);
    }

    private class IdleConnectionHarvester
    implements Runnable {
        private IdleConnectionHarvester() {
        }

        @Override
        public void run() {
            AdvancedConnectionPool.this.harvestExpiredIdleConnections();
        }
    }

    private class IdleConnectionHarvesterThreadFactory
    implements ThreadFactory {
        private static final String THREAD_NAME = "IdleConnectionHarvester";
        private static final String THREAD_GROUP_NAME = "IdleConnectionHarvesters";
        private final ThreadGroup threadGroup = new ThreadGroup("IdleConnectionHarvesters");

        private IdleConnectionHarvesterThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.threadGroup, runnable, THREAD_NAME);
            return thread;
        }
    }
}

