/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.database.connection.pool;

import com.ibm.arcs.database.connection.ConnectionPool;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class PooledConnectionEventListener
implements ConnectionEventListener {
    private final ConnectionPool connectionPoolManager;

    public PooledConnectionEventListener(ConnectionPool connectionPool) {
        this.connectionPoolManager = connectionPool;
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        pooledConnection.removeConnectionEventListener(this);
        this.connectionPoolManager.returnConnection(pooledConnection);
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        pooledConnection.removeConnectionEventListener(this);
        this.connectionPoolManager.disposeConnection(pooledConnection);
    }
}

