/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.host;

import com.ibm.arcs.host.HostName;
import com.ibm.arcs.host.OperatingEnvironment;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Vector;

public class Host
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Vector<HostName> hostNames = new Vector();
    private OperatingEnvironment operatingEnvironment = null;

    Host() {
    }

    public HostName addHostName(String string) {
        HostName hostName = new HostName(string, this);
        this.hostNames.add(hostName);
        return hostName;
    }

    public void removeHostName(HostName hostName) {
        this.hostNames.remove(hostName);
    }

    public Vector<HostName> getHostNames() {
        return new Vector<HostName>(this.hostNames);
    }

    public OperatingEnvironment getOperatingEnvironment() {
        if (this.operatingEnvironment == null) {
            this.operatingEnvironment = new OperatingEnvironment(this);
        }
        return this.operatingEnvironment;
    }

    public static boolean isLocalHost(String string) {
        try {
            String string2 = InetAddress.getByName(string).getHostAddress();
            return Host.isLocalHostAddress(string2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isLocalHostAddress(String string) {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            block2: while (true) {
                InetAddress inetAddress;
                if (!enumeration.hasMoreElements()) {
                    return false;
                }
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                do {
                    if (!enumeration2.hasMoreElements()) continue block2;
                    inetAddress = enumeration2.nextElement();
                    if (inetAddress.getHostAddress().contentEquals(string)) return true;
                } while (!inetAddress.getHostName().contentEquals(string));
                break;
            }
            return true;
        }
        catch (SocketException socketException) {
            System.err.println(socketException.getMessage());
        }
        return false;
    }

    public boolean isLocalHost() {
        for (HostName hostName : this.hostNames) {
            if (!Host.isLocalHost(hostName.getName())) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.hostNames == null ? 0 : this.hostNames.hashCode());
        n = 31 * n + (this.operatingEnvironment == null ? 0 : this.operatingEnvironment.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Host)) {
            return false;
        }
        Host host = (Host)object;
        if (this.hostNames == null ? host.hostNames != null : !this.hostNames.equals(host.hostNames)) {
            return false;
        }
        return !(this.operatingEnvironment == null ? host.operatingEnvironment != null : !this.operatingEnvironment.equals(host.operatingEnvironment));
    }
}

