/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.host;

import com.ibm.arcs.host.HostName;
import java.io.Serializable;
import java.net.InetAddress;

public class HostAddress
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int IPV4_NUMBER_OF_COMPONENTS = 4;
    private static final int IPV4_COMPONENT_MIN = 0;
    private static final int IPV4_COMPONENT_MAX = 255;
    private static final int IPV6_NUMBER_OF_COMPONENTS_MIN = 3;
    private static final int IPV6_NUMBER_OF_COMPONENTS_MAX = 8;
    private InetAddress inetAddress;
    private HostName hostName;

    private HostAddress() {
    }

    HostAddress(InetAddress inetAddress, HostName hostName) {
        this();
        this.inetAddress = inetAddress;
        this.hostName = hostName;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public HostName getHostName() {
        return this.hostName;
    }

    public static boolean isIPv4Address(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 4) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                try {
                    Integer n3 = Integer.parseInt(string2);
                    if (n3 < 0 || n3 > 255) {
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public static boolean isIPv6Address(String string) {
        String[] stringArray = string.split("\\:");
        if (3 <= stringArray.length && stringArray.length <= 8) {
            return HostAddress.isPreferredFormIPv6Address(string);
        }
        return false;
    }

    private static boolean isPreferredFormIPv6Address(String string) {
        String[] stringArray = string.split("\\:");
        if (stringArray.length == 8) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                if (!string2.matches("[0-9a-fA-F][0-9a-fA-F]{0,3}")) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.inetAddress == null ? 0 : this.inetAddress.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof HostAddress)) {
            return false;
        }
        HostAddress hostAddress = (HostAddress)object;
        return !(this.inetAddress == null ? hostAddress.inetAddress != null : !this.inetAddress.equals(hostAddress.inetAddress));
    }
}

