/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.host;

import com.ibm.arcs.host.Host;
import com.ibm.arcs.host.HostAddress;
import com.ibm.arcs.host.HostName;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HostCatalog {
    private static ArrayList<Host> cache = new ArrayList();
    public static final String LOCALHOST = "localhost";
    private static Host localHost = null;
    private static final Logger logger = LoggerFactory.getLogger(HostCatalog.class);

    private HostCatalog() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Host getNewHost() {
        Host host;
        ArrayList<Host> arrayList = cache;
        synchronized (arrayList) {
            host = new Host();
            cache.add(host);
        }
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Host[] getAllHosts() {
        Host[] hostArray;
        ArrayList<Host> arrayList = cache;
        synchronized (arrayList) {
            hostArray = cache.toArray(new Host[cache.size()]);
        }
        return hostArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Host[] getAllHostsWithName(String string) {
        Vector<Host> vector = new Vector<Host>();
        ArrayList<Host> arrayList = cache;
        synchronized (arrayList) {
            for (Host host : cache) {
                for (HostName hostName : host.getHostNames()) {
                    if (!hostName.getName().equalsIgnoreCase(string)) continue;
                    vector.add(host);
                }
            }
        }
        return vector.toArray(new Host[vector.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Host[] getAllHostsWithNameOrAddress(String string) {
        Vector<Host> vector = new Vector<Host>();
        ArrayList<Host> arrayList = cache;
        synchronized (arrayList) {
            for (Host host : cache) {
                block4: for (HostName hostName : host.getHostNames()) {
                    List<HostAddress> list = hostName.getHostAddresses();
                    for (HostAddress hostAddress : list) {
                        InetAddress inetAddress = hostAddress.getInetAddress();
                        if (!inetAddress.getHostName().equalsIgnoreCase(string) && !inetAddress.getHostAddress().equalsIgnoreCase(string) && !hostName.getName().equalsIgnoreCase(string)) continue;
                        vector.add(host);
                        continue block4;
                    }
                }
            }
        }
        return vector.toArray(new Host[vector.size()]);
    }

    public static Host getLocalHost() {
        logger.debug("getLocalHost()");
        if (localHost != null) {
            logger.debug("localhost already defined, returning existing definition");
            return localHost;
        }
        localHost = HostCatalog.getNewHost();
        HostCatalog.addAllLocalHostInterfaces(localHost);
        return localHost;
    }

    public static HostName getLocalHostNameWithName(String string) throws IllegalArgumentException {
        Host host = HostCatalog.getLocalHost();
        for (HostName hostName : host.getHostNames()) {
            if (!hostName.getName().equalsIgnoreCase(string)) continue;
            return hostName;
        }
        throw new IllegalArgumentException("The local host is not associated with specified name");
    }

    private static void addAllLocalHostInterfaces(Host host) {
        logger.debug("enumerating all network interfaces and attaching to localhost");
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                logger.trace("nwif = " + networkInterface.getDisplayName());
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    String string = inetAddress.getCanonicalHostName();
                    logger.trace("  inad = " + inetAddress.getHostAddress());
                    logger.trace("  canonicalHostName = " + string);
                    HostName hostName = host.addHostName(string);
                    hostName.addHostAddress(inetAddress);
                }
            }
        }
        catch (SocketException socketException) {
            logger.error("socket exception occurred during enumeration of localhost network interfaces", (Throwable)socketException);
        }
    }
}

