/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.host;

import com.ibm.arcs.host.Host;
import com.ibm.arcs.host.HostAddress;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class HostName
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Host host;
    private ArrayList<HostAddress> hostAddresses;

    private HostName() {
    }

    HostName(String string, Host host) {
        this();
        this.name = string;
        this.host = host;
        this.hostAddresses = new ArrayList(1);
    }

    public HostName createAlias(String string) {
        HostName hostName = new HostName(string, this.getHost());
        hostName.hostAddresses = this.hostAddresses;
        return hostName;
    }

    public static HostAddress[] getHostAddresseses(HostName hostName) throws UnknownHostException {
        InetAddress[] inetAddressArray = InetAddress.getAllByName(hostName.getName());
        HostAddress[] hostAddressArray = new HostAddress[inetAddressArray.length];
        int n = 0;
        while (n < inetAddressArray.length) {
            hostAddressArray[n] = new HostAddress(inetAddressArray[n], hostName);
            ++n;
        }
        return hostAddressArray;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHostAddress(InetAddress inetAddress) {
        ArrayList<HostAddress> arrayList = this.hostAddresses;
        synchronized (arrayList) {
            this.hostAddresses.add(new HostAddress(inetAddress, this));
        }
    }

    public Host getHost() {
        return this.host;
    }

    public List<HostAddress> getHostAddresses() {
        return this.hostAddresses;
    }

    public String toString() {
        return this.name;
    }

    public static boolean isEmpty(HostName hostName) {
        return hostName == null || hostName.getName() == null || hostName.getName().trim().length() > 0;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.hostAddresses == null ? 0 : this.hostAddresses.hashCode());
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof HostName)) {
            return false;
        }
        HostName hostName = (HostName)object;
        if (this.hostAddresses == null ? hostName.hostAddresses != null : !this.hostAddresses.equals(hostName.hostAddresses)) {
            return false;
        }
        return !(this.name == null ? hostName.name != null : !this.name.equals(hostName.name));
    }
}

