/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.host;

import com.ibm.arcs.host.ISAType;
import java.io.Serializable;

public class ISA
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ISAType isaType;
    private final String isaVersion;

    public ISA(ISAType iSAType, String string) {
        this.isaType = iSAType;
        this.isaVersion = string;
    }

    public static ISA getLocalHostISA() {
        String string = System.getProperty("os.arch");
        if (string.equals("x86") || string.equals("i386") || string.equals("amd64") || string.equals("x86_64")) {
            return new ISA(ISAType.x86, "1.0");
        }
        if (string.contains("IA64")) {
            return new ISA(ISAType.Itanium, "1.0");
        }
        if (string.equals("ppc") || string.equals("ppc64")) {
            return new ISA(ISAType.POWER, "1.0");
        }
        if (string.equals("PA_RISC2.0")) {
            return new ISA(ISAType.PA_RISC, "2.0");
        }
        if (string.equals("sparc")) {
            return new ISA(ISAType.SPARC, "7.0");
        }
        if (string.equals("sparcv9")) {
            return new ISA(ISAType.SPARC, "9.0");
        }
        if (string.contains("s390")) {
            return new ISA(ISAType.S390, "1.0");
        }
        throw new RuntimeException("Localhost uses unsupported ISA");
    }

    public ISAType getISAType() {
        return this.isaType;
    }

    public String getISAVersion() {
        return this.isaVersion;
    }

    public String toString() {
        return String.valueOf(this.isaType.name()) + " " + this.isaVersion;
    }
}

