/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.host;

import com.ibm.arcs.host.Host;
import com.ibm.arcs.host.KernelType;
import com.ibm.arcs.host.KernelVersion;
import com.ibm.arcs.host.OperatingEnvironment;
import com.ibm.arcs.host.PlatformBits;
import java.io.Serializable;

public class Kernel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private OperatingEnvironment operatingEnvironment;
    private KernelType kernelType;
    private PlatformBits kernelBits;
    private KernelVersion kernelVersion;

    public Kernel(KernelType kernelType, PlatformBits platformBits, KernelVersion kernelVersion) {
        this.kernelType = kernelType;
        this.kernelBits = platformBits;
        this.kernelVersion = kernelVersion;
    }

    public static Kernel getKernel(OperatingEnvironment operatingEnvironment) {
        Host host = operatingEnvironment.getHost();
        if (host.isLocalHost()) {
            return Kernel.getLocalHostKernel();
        }
        return Kernel.getRemoteHostKernel(host);
    }

    public KernelType getKernelType() {
        return this.kernelType;
    }

    public PlatformBits getKernelBits() {
        return this.kernelBits;
    }

    public KernelVersion getKernelVersion() {
        return this.kernelVersion;
    }

    private static Kernel getRemoteHostKernel(Host host) {
        return null;
    }

    private static Kernel getLocalHostKernel() {
        return new Kernel(Kernel.getLocalHostKernelType(), Kernel.getLocalHostKernelBits(), null);
    }

    private static KernelType getLocalHostKernelType() {
        String string = System.getProperty("os.name");
        if (string.equals("AIX")) {
            return KernelType.AIX;
        }
        if (string.equals("HP-UX")) {
            return KernelType.HPUX;
        }
        if (string.equals("Linux")) {
            return KernelType.Linux;
        }
        if (string.equals("Mac OS X")) {
            return KernelType.Darwin;
        }
        if (string.equals("SunOS")) {
            return KernelType.SunOS;
        }
        if (string.startsWith("Windows")) {
            return KernelType.Windows;
        }
        return KernelType.UNKNOWN;
    }

    private static PlatformBits getLocalHostKernelBits() {
        String string = System.getProperty("sun.arch.data.model");
        if (string.equals("32")) {
            return PlatformBits.ThirtyTwo;
        }
        if (string.equals("64")) {
            return PlatformBits.SixtyFour;
        }
        throw new RuntimeException("Unsupported local host kernel bits");
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.kernelBits == null ? 0 : this.kernelBits.hashCode());
        n = 31 * n + (this.kernelType == null ? 0 : this.kernelType.hashCode());
        n = 31 * n + (this.kernelVersion == null ? 0 : this.kernelVersion.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Kernel)) {
            return false;
        }
        Kernel kernel = (Kernel)object;
        if (this.kernelBits != kernel.kernelBits) {
            return false;
        }
        if (this.kernelType != kernel.kernelType) {
            return false;
        }
        return !(this.kernelVersion == null ? kernel.kernelVersion != null : !this.kernelVersion.equals(kernel.kernelVersion));
    }
}

